/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools.time;

import de.lessvoid.nifty.tools.TimeProvider;
import de.lessvoid.nifty.tools.time.interpolator.ExpTime;
import de.lessvoid.nifty.tools.time.interpolator.Interpolator;
import de.lessvoid.nifty.tools.time.interpolator.LinearTime;
import de.lessvoid.nifty.tools.time.interpolator.NullTime;
import de.lessvoid.nifty.tools.time.interpolator.OneTime;
import java.util.Properties;
import java.util.logging.Logger;

public class TimeInterpolator {
    private static Logger log = Logger.getLogger(TimeInterpolator.class.getName());
    private TimeProvider timeProvider;
    private Interpolator interpolatorProvider;
    private float value = 0.0f;
    private long startTime;
    private long lengthParam;
    private long startDelayParam = 0L;

    public TimeInterpolator(Properties parameter, TimeProvider newTimeProvider, boolean infinite) {
        this.timeProvider = newTimeProvider;
        this.startDelayParam = Long.parseLong(parameter.getProperty("startDelay", "0"));
        String lengthDefault = null;
        if (infinite) {
            lengthDefault = "infinite";
        }
        this.interpolatorProvider = null;
        if ("infinite".equals(parameter.getProperty("length", lengthDefault))) {
            this.interpolatorProvider = new NullTime();
        } else {
            this.lengthParam = Long.parseLong(parameter.getProperty("length", "1000"));
            if (Boolean.parseBoolean(parameter.getProperty("oneShot"))) {
                this.interpolatorProvider = new OneTime();
            }
        }
        if (this.interpolatorProvider == null) {
            String timeType = parameter.getProperty("timeType", "linear");
            if (timeType.equals("infinite")) {
                this.interpolatorProvider = new NullTime();
            } else if (timeType.equals("linear")) {
                this.interpolatorProvider = new LinearTime();
            } else if (timeType.equals("exp")) {
                this.interpolatorProvider = new ExpTime();
            } else {
                log.warning(timeType + " is not supported, using NullTime for fallback. probably not what you want...");
                this.interpolatorProvider = new NullTime();
            }
        }
        this.interpolatorProvider.initialize(parameter);
    }

    public void start() {
        this.interpolatorProvider.start();
        this.value = 0.0f;
        this.startTime = this.timeProvider.getMsTime() + this.startDelayParam;
    }

    public final boolean update() {
        long now = this.timeProvider.getMsTime();
        long timePassed = now - this.startTime;
        if (timePassed < 0L) {
            return true;
        }
        this.value = this.interpolatorProvider.getValue(this.lengthParam, timePassed);
        if (this.value > 1.0f) {
            this.value = 1.0f;
            return false;
        }
        return true;
    }

    public final float getValue() {
        return this.value;
    }
}

