/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollbar;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Scrollbar;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import java.util.logging.Logger;

public class UpdateScrollpanelPositionToDisplayElement
implements EffectImpl {
    private Logger log = Logger.getLogger(UpdateScrollpanelPositionToDisplayElement.class.getName());
    private Element targetElement;

    public void activate(Nifty nifty, Element elementParameter, EffectProperties parameter) {
        String target = parameter.getProperty("target");
        if (target != null) {
            this.targetElement = nifty.getCurrentScreen().findElementByName(target);
        }
    }

    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        if (this.targetElement != null) {
            Scrollbar verticalScrollbar = (Scrollbar)this.targetElement.findNiftyControl("#nifty-internal-vertical-scrollbar", Scrollbar.class);
            int minY = (int)verticalScrollbar.getValue();
            int maxY = (int)verticalScrollbar.getValue() + (int)verticalScrollbar.getWorldPageSize();
            int currentMinY = element.getY() - this.targetElement.getY() + (int)verticalScrollbar.getValue();
            int currentMaxY = element.getY() - this.targetElement.getY() + element.getHeight() + (int)verticalScrollbar.getValue();
            int delta = -1;
            if (currentMinY >= maxY || currentMinY <= maxY && currentMaxY >= maxY) {
                delta = currentMaxY - maxY;
                verticalScrollbar.setValue(minY + delta);
            } else if (currentMaxY <= minY || currentMinY <= minY && currentMaxY >= minY) {
                delta = minY - currentMinY;
                verticalScrollbar.setValue(minY - delta);
            }
            this.log.fine(minY + ":" + maxY + " - " + currentMinY + ":" + currentMaxY + " - " + delta);
        }
    }

    public void deactivate() {
    }
}

