/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt;

import com.jogamp.common.util.locks.RecursiveLock;
import java.awt.Component;
import java.awt.Window;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Point;
import javax.media.nativewindow.util.Rectangle;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_Rectangle;

public abstract class JAWTWindow
implements NativeWindow {
    protected static final boolean DEBUG = JAWTUtil.DEBUG;
    protected Component component;
    protected AbstractGraphicsConfiguration config;
    protected long drawable;
    protected Rectangle bounds;
    private RecursiveLock recurLock = new RecursiveLock();

    public JAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (abstractGraphicsConfiguration == null) {
            throw new NativeWindowException("Error: AbstractGraphicsConfiguration is null");
        }
        this.config = abstractGraphicsConfiguration;
        this.init((Component)object);
    }

    private final void init(Component component) throws NativeWindowException {
        this.invalidate();
        this.component = component;
        this.validateNative();
    }

    protected abstract void validateNative() throws NativeWindowException;

    protected synchronized void invalidate() {
        this.component = null;
        this.drawable = 0L;
        this.bounds = new Rectangle();
    }

    protected final void updateBounds(JAWT_Rectangle jAWT_Rectangle) {
        this.bounds.setX(jAWT_Rectangle.getX());
        this.bounds.setY(jAWT_Rectangle.getY());
        this.bounds.setWidth(jAWT_Rectangle.getWidth());
        this.bounds.setHeight(jAWT_Rectangle.getHeight());
    }

    public final Rectangle getBounds() {
        return this.bounds;
    }

    public final Component getAWTComponent() {
        return this.component;
    }

    @Override
    public final void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
    }

    protected abstract int lockSurfaceImpl() throws NativeWindowException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int lockSurface() throws NativeWindowException {
        int n = 1;
        this.recurLock.lock();
        if (this.recurLock.getRecursionCount() == 0) {
            this.config.getScreen().getDevice().lock();
            try {
                n = this.lockSurfaceImpl();
            }
            finally {
                if (1 >= n) {
                    this.config.getScreen().getDevice().unlock();
                    this.recurLock.unlock();
                }
            }
        } else {
            n = 3;
        }
        return n;
    }

    protected abstract void unlockSurfaceImpl() throws NativeWindowException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        this.recurLock.validateLocked();
        if (this.recurLock.getRecursionCount() == 0) {
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                this.config.getScreen().getDevice().unlock();
            }
        }
        this.recurLock.unlock();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.recurLock.isLockedByOtherThread();
    }

    @Override
    public final boolean isSurfaceLocked() {
        return this.recurLock.isLocked();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.recurLock.getOwner();
    }

    @Override
    public final boolean surfaceSwap() {
        return false;
    }

    public final void surfaceUpdated(Object object, NativeWindow nativeWindow, long l) {
    }

    @Override
    public final long getSurfaceHandle() {
        return this.drawable;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    @Override
    public final long getDisplayHandle() {
        return this.config.getScreen().getDevice().getHandle();
    }

    @Override
    public final int getScreenIndex() {
        return this.config.getScreen().getIndex();
    }

    public final void setSize(int n, int n2) {
        this.component.setSize(n, n2);
    }

    @Override
    public final int getWidth() {
        return this.component.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.component.getHeight();
    }

    @Override
    public synchronized void destroy() {
        if (null != this.component && this.component instanceof Window) {
            ((Window)this.component).dispose();
        }
        this.invalidate();
    }

    @Override
    public final NativeWindow getParent() {
        return null;
    }

    @Override
    public long getWindowHandle() {
        return this.drawable;
    }

    @Override
    public final int getX() {
        return this.component.getX();
    }

    @Override
    public final int getY() {
        return this.component.getY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen(Point point) {
        Cloneable cloneable;
        if (0L != this.getWindowHandle()) {
            cloneable = this.getLocationOnScreenImpl(0, 0);
            if (null != cloneable) {
                if (null != point) {
                    point.translate(((Point)cloneable).getX(), ((Point)cloneable).getY());
                    return point;
                }
                return cloneable;
            }
        }
        if (!Thread.holdsLock(this.component.getTreeLock())) {
            return null;
        }
        cloneable = this.component.getLocationOnScreen();
        int n = (int)(((java.awt.Point)cloneable).getX() + 0.5);
        int n2 = (int)(((java.awt.Point)cloneable).getY() + 0.5);
        if (null != point) {
            return point.translate(n, n2);
        }
        return new Point(n, n2);
    }

    protected abstract Point getLocationOnScreenImpl(int var1, int var2);

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JAWT-Window[windowHandle 0x" + Long.toHexString(this.getWindowHandle()) + ", surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle()) + ", bounds " + this.bounds);
        if (null != this.component) {
            stringBuffer.append(", pos " + this.getX() + "/" + this.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ", visible " + this.component.isVisible());
        } else {
            stringBuffer.append(", component NULL");
        }
        stringBuffer.append(", lockedExt " + this.isSurfaceLockedByOtherThread() + ",\n\tconfig " + this.config + ",\n\tawtComponent " + this.getAWTComponent() + "]");
        return stringBuffer.toString();
    }
}

