/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.x11;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.awt.AWTGraphicsConfiguration;

public class X11SunJDKReflection {
    private static Class x11GraphicsDeviceClass;
    private static Method x11GraphicsDeviceGetDisplayMethod;
    private static Class x11GraphicsConfigClass;
    private static Method x11GraphicsConfigGetVisualMethod;
    private static boolean initted;

    public static long graphicsDeviceGetDisplay(GraphicsDevice graphicsDevice) {
        if (!initted) {
            return 0L;
        }
        try {
            return (Long)x11GraphicsDeviceGetDisplayMethod.invoke((Object)graphicsDevice, (Object[])null);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static int graphicsConfigurationGetVisualID(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        try {
            if (abstractGraphicsConfiguration instanceof AWTGraphicsConfiguration) {
                return X11SunJDKReflection.graphicsConfigurationGetVisualID(((AWTGraphicsConfiguration)abstractGraphicsConfiguration).getGraphicsConfiguration());
            }
            return 0;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int graphicsConfigurationGetVisualID(GraphicsConfiguration graphicsConfiguration) {
        if (!initted) {
            return 0;
        }
        try {
            return (Integer)x11GraphicsConfigGetVisualMethod.invoke((Object)graphicsConfiguration, (Object[])null);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    x11GraphicsDeviceClass = Class.forName("sun.awt.X11GraphicsDevice");
                    x11GraphicsDeviceGetDisplayMethod = x11GraphicsDeviceClass.getDeclaredMethod("getDisplay", new Class[0]);
                    x11GraphicsDeviceGetDisplayMethod.setAccessible(true);
                    x11GraphicsConfigClass = Class.forName("sun.awt.X11GraphicsConfig");
                    x11GraphicsConfigGetVisualMethod = x11GraphicsConfigClass.getDeclaredMethod("getVisual", new Class[0]);
                    x11GraphicsConfigGetVisualMethod.setAccessible(true);
                    initted = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

