/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.Platform;
import java.nio.ByteBuffer;
import jogamp.nativewindow.x11.Visual32;
import jogamp.nativewindow.x11.Visual64;

public abstract class Visual {
    StructAccessor accessor;

    public static int size() {
        if (Platform.is32Bit()) {
            return Visual32.size();
        }
        return Visual64.size();
    }

    public static Visual create() {
        return Visual.create(Buffers.newDirectByteBuffer((int)Visual.size()));
    }

    public static Visual create(ByteBuffer byteBuffer) {
        if (Platform.is32Bit()) {
            return new Visual32(byteBuffer);
        }
        return new Visual64(byteBuffer);
    }

    Visual(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }
}

