/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayHashSet
implements Cloneable,
Collection,
List {
    HashMap map = new HashMap();
    ArrayList data = new ArrayList();

    public ArrayHashSet() {
        this.clear();
    }

    public final Object clone() {
        ArrayList clonedList = (ArrayList)this.data.clone();
        ArrayHashSet newObj = new ArrayHashSet();
        newObj.addAll((Collection)clonedList);
        return newObj;
    }

    @Override
    public final void clear() {
        this.data.clear();
        this.map.clear();
    }

    @Override
    public final boolean add(Object element) {
        boolean exists = this.map.containsKey(element);
        if (!exists) {
            if (null != this.map.put(element, element)) {
                throw new InternalError("Already existing, but checked before: " + element);
            }
            if (!this.data.add(element)) {
                throw new InternalError("Couldn't add element: " + element);
            }
        }
        return !exists;
    }

    @Override
    public final boolean remove(Object element) {
        if (null != this.map.remove(element)) {
            if (!this.data.remove(element)) {
                throw new InternalError("Couldn't remove prev mapped element: " + element);
            }
            return true;
        }
        return false;
    }

    @Override
    public final boolean addAll(Collection c) {
        boolean mod = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            mod = mod || this.add(iter.next());
        }
        return mod;
    }

    @Override
    public final boolean contains(Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public final boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean removeAll(Collection c) {
        boolean mod = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            mod = this.remove(iter.next()) || mod;
        }
        return mod;
    }

    @Override
    public final boolean retainAll(Collection c) {
        boolean mod = false;
        for (Object o : this) {
            if (c.contains(o)) continue;
            mod = this.remove(o) || mod;
        }
        return mod;
    }

    @Override
    public final boolean equals(Object arrayHashSet) {
        if (!(arrayHashSet instanceof ArrayHashSet)) {
            return false;
        }
        return this.data.equals(((ArrayHashSet)arrayHashSet).data);
    }

    @Override
    public final int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final Iterator iterator() {
        return this.data.iterator();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final Object[] toArray() {
        return this.data.toArray();
    }

    @Override
    public final Object[] toArray(Object[] a) {
        return this.data.toArray(a);
    }

    public final Object get(int index) {
        return this.data.get(index);
    }

    @Override
    public final int indexOf(Object element) {
        return this.data.indexOf(element);
    }

    public final void add(int index, Object element) {
        if (this.map.containsKey(element)) {
            throw new IllegalArgumentException("Element " + element + " is already contained");
        }
        if (null != this.map.put(element, element)) {
            throw new InternalError("Already existing, but checked before: " + element);
        }
        this.data.add(index, element);
    }

    public final boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public final Object set(int index, Object element) {
        Object old = this.remove(index);
        if (null != old) {
            this.add(index, element);
        }
        return old;
    }

    public final Object remove(int index) {
        Object o = this.get(index);
        if (null != o && this.remove(o)) {
            return o;
        }
        return null;
    }

    @Override
    public final int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    public final ListIterator listIterator() {
        return this.data.listIterator();
    }

    public final ListIterator listIterator(int index) {
        return this.data.listIterator(index);
    }

    public final List subList(int fromIndex, int toIndex) {
        return this.data.subList(fromIndex, toIndex);
    }

    public final ArrayList toArrayList() {
        return (ArrayList)this.data.clone();
    }

    public final Object get(Object key) {
        return this.map.get(key);
    }

    public final Object getOrAdd(Object key) {
        Object identity = this.get(key);
        if (null == identity) {
            if (!this.add(key)) {
                throw new InternalError("Key not mapped, but contained in list: " + key);
            }
            identity = key;
        }
        return identity;
    }

    public final boolean containsSafe(Object element) {
        return this.data.contains(element);
    }
}

