/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLArrayData;
import javax.media.opengl.GLException;
import jogamp.opengl.util.glsl.fixedfunc.FixedFuncPipeline;

public class GLArrayDataWrapper
implements GLArrayData {
    protected int index;
    protected int location;
    protected String name;
    protected int components;
    protected int dataType;
    protected boolean normalized;
    protected int stride;
    protected int strideB;
    protected int strideL;
    protected Class clazz;
    protected Buffer buffer;
    protected boolean isVertexAttribute;
    protected long bufferOffset;
    protected int vboName;
    protected boolean vboUsage;

    public static GLArrayDataWrapper createFixed(GL gL, int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, long l) throws GLException {
        gL.getGLProfile().isValidArrayDataType(n, n2, n3, false, true);
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(null, n, n2, n3, bl, n4, buffer, false, n5, l);
        return gLArrayDataWrapper;
    }

    public static GLArrayDataWrapper createGLSL(GL gL, String string, int n, int n2, boolean bl, int n3, Buffer buffer, int n4, long l) throws GLException {
        if (!gL.hasGLSL()) {
            throw new GLException("GLArrayDataWrapper.GLSL not supported: " + gL);
        }
        gL.getGLProfile().isValidArrayDataType(-1, n, n2, true, true);
        GLArrayDataWrapper gLArrayDataWrapper = new GLArrayDataWrapper();
        gLArrayDataWrapper.init(string, -1, n, n2, bl, n3, buffer, true, n4, l);
        return gLArrayDataWrapper;
    }

    @Override
    public final boolean isVertexAttribute() {
        return this.isVertexAttribute;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final int getLocation() {
        return this.location;
    }

    @Override
    public final void setLocation(int n) {
        this.location = n;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final long getOffset() {
        return this.vboUsage ? this.bufferOffset : -1L;
    }

    @Override
    public final int getVBOName() {
        return this.vboUsage ? this.vboName : -1;
    }

    @Override
    public final boolean isVBO() {
        return this.vboUsage;
    }

    @Override
    public final Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final int getComponentNumber() {
        return this.components;
    }

    @Override
    public final int getComponentType() {
        return this.dataType;
    }

    @Override
    public final int getComponentSize() {
        if (this.clazz == ByteBuffer.class) {
            return 1;
        }
        if (this.clazz == ShortBuffer.class) {
            return 2;
        }
        if (this.clazz == IntBuffer.class) {
            return 4;
        }
        if (this.clazz == FloatBuffer.class) {
            return 4;
        }
        throw new GLException("Given Buffer Class not supported: " + this.clazz + ":\n\t" + this);
    }

    @Override
    public final int getElementNumber() {
        if (null == this.buffer) {
            return 0;
        }
        return this.buffer.position() == 0 ? this.buffer.limit() / this.components : this.buffer.position() / this.components;
    }

    @Override
    public final boolean getNormalized() {
        return this.normalized;
    }

    @Override
    public final int getStride() {
        return this.stride;
    }

    public final Class getBufferClass() {
        return this.clazz;
    }

    @Override
    public void destroy(GL gL) {
        this.buffer = null;
        this.components = 0;
        this.stride = 0;
        this.strideB = 0;
        this.strideL = 0;
        this.vboName = 0;
        this.vboUsage = false;
        this.bufferOffset = 0L;
    }

    @Override
    public String toString() {
        return "GLArrayDataWrapper[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttribute + ", dataType " + this.dataType + ", bufferClazz " + this.clazz + ", elements " + this.getElementNumber() + ", components " + this.components + ", stride " + this.stride + "u " + this.strideB + "b " + this.strideL + "c" + ", buffer " + this.buffer + ", offset " + this.bufferOffset + ", vboUsage " + this.vboUsage + ", vboName " + this.vboName + "]";
    }

    public static final Class getBufferClass(int n) {
        switch (n) {
            case 5120: 
            case 5121: {
                return ByteBuffer.class;
            }
            case 5122: 
            case 5123: {
                return ShortBuffer.class;
            }
            case 5132: {
                return IntBuffer.class;
            }
            case 5126: {
                return FloatBuffer.class;
            }
        }
        throw new GLException("Given OpenGL data type not supported: " + n);
    }

    @Override
    public void setName(String string) {
        this.location = -1;
        this.name = string;
    }

    public void setVBOUsage(boolean bl) {
        this.vboUsage = bl;
    }

    public void setVBOName(int n) {
        this.vboName = n;
        this.setVBOUsage(n > 0);
    }

    protected void init(String string, int n, int n2, int n3, boolean bl, int n4, Buffer buffer, boolean bl2, int n5, long l) throws GLException {
        this.isVertexAttribute = bl2;
        this.index = n;
        this.location = -1;
        String string2 = this.name = null == string ? FixedFuncPipeline.getPredefinedArrayIndexName(n) : string;
        if (null == this.name) {
            throw new GLException("Not a valid GL array index: " + n);
        }
        this.dataType = n3;
        this.clazz = GLArrayDataWrapper.getBufferClass(n3);
        switch (n3) {
            case 5120: 
            case 5121: 
            case 5122: 
            case 5123: 
            case 5132: {
                this.normalized = bl;
                break;
            }
            default: {
                this.normalized = false;
            }
        }
        int n6 = this.getComponentSize();
        if (0 < n4 && n4 < n2 * n6) {
            throw new GLException("stride (" + n4 + ") lower than component bytes, " + n2 + " * " + n6);
        }
        if (0 < n4 && n4 % n6 != 0) {
            throw new GLException("stride (" + n4 + ") not a multiple of bpc " + n6);
        }
        this.buffer = buffer;
        this.components = n2;
        this.stride = n4;
        this.strideB = 0 == n4 ? n2 * n6 : n4;
        this.strideL = 0 == n4 ? n2 : this.strideB / n6;
        this.vboName = n5;
        this.vboUsage = n5 > 0;
        this.bufferOffset = l;
    }

    protected GLArrayDataWrapper() {
    }
}

