/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl.awt;

import java.awt.Graphics;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.awt.Java2D;
import jogamp.opengl.awt.Java2DGLContext;
import jogamp.opengl.macosx.cgl.MacOSXCGLContext;
import jogamp.opengl.macosx.cgl.MacOSXPbufferCGLContext;

public class MacOSXJava2DCGLContext
extends MacOSXCGLContext
implements Java2DGLContext {
    private Graphics graphics;

    MacOSXJava2DCGLContext(GLContext gLContext) {
        super(null, gLContext);
    }

    @Override
    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
    }

    @Override
    protected void makeCurrentImpl(boolean bl) throws GLException {
        if (!Java2D.makeOGLContextCurrentOnSurface(this.graphics, this.contextHandle)) {
            throw new GLException("Error making context current");
        }
    }

    @Override
    protected boolean createImpl() {
        long l;
        MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)GLContextShareSet.getShareContext(this);
        long l2 = 0L;
        if (macOSXCGLContext != null) {
            if (macOSXCGLContext instanceof MacOSXPbufferCGLContext) {
                MacOSXPbufferCGLContext macOSXPbufferCGLContext = (MacOSXPbufferCGLContext)macOSXCGLContext;
                macOSXPbufferCGLContext.setOpenGLMode(2);
            } else if (macOSXCGLContext.getOpenGLMode() != 2) {
                throw new GLException("Can't share between NSOpenGLContexts and CGLContextObjs");
            }
            l2 = macOSXCGLContext.getHandle();
        }
        if (DEBUG) {
            System.err.println("!!! Share context is " + MacOSXJava2DCGLContext.toHexString(l2) + " for " + this.getClass().getName());
        }
        if ((l = Java2D.createOGLContextOnSurface(this.graphics, l2)) == 0L) {
            return false;
        }
        this.setGLFunctionAvailability(true, 0, 0, 34);
        this.contextHandle = l;
        this.isNSContext = true;
        return true;
    }

    @Override
    protected void releaseImpl() throws GLException {
    }

    @Override
    protected void destroyImpl() throws GLException {
        Java2D.destroyOGLContext(this.contextHandle);
        if (DEBUG) {
            System.err.println("!!! Destroyed OpenGL context " + this.contextHandle);
        }
    }

    @Override
    public void setOpenGLMode(int n) {
        if (n != 2) {
            throw new GLException("OpenGL mode switching not supported for Java2D GLContexts");
        }
    }

    @Override
    public int getOpenGLMode() {
        return 2;
    }
}

