/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.PIXELFORMATDESCRIPTOR;
import jogamp.opengl.Debug;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.windows.wgl.WGLExt;
import jogamp.opengl.windows.wgl.WGLGLCapabilities;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawableFactory;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsWGLGraphicsConfiguration
extends DefaultGraphicsConfiguration
implements Cloneable {
    protected static final boolean DEBUG = Debug.debug("GraphicsConfiguration");
    static final String WGL_ARB_pixel_format = "WGL_ARB_pixel_format";
    static final String WGL_ARB_multisample = "WGL_ARB_multisample";
    protected static final int MAX_PFORMATS = 256;
    protected static final int MAX_ATTRIBS = 256;
    private GLCapabilitiesChooser chooser;
    private boolean isChosen = false;

    WindowsWGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(abstractGraphicsScreen, (CapabilitiesImmutable)gLCapabilitiesImmutable, (CapabilitiesImmutable)gLCapabilitiesImmutable2);
        this.chooser = gLCapabilitiesChooser;
        this.isChosen = false;
    }

    WindowsWGLGraphicsConfiguration(AbstractGraphicsScreen abstractGraphicsScreen, WGLGLCapabilities wGLGLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        super(abstractGraphicsScreen, (CapabilitiesImmutable)wGLGLCapabilities, (CapabilitiesImmutable)gLCapabilitiesImmutable);
        this.setCapsPFD(wGLGLCapabilities);
        this.chooser = null;
    }

    static WindowsWGLGraphicsConfiguration createFromCurrent(GLDrawableFactory gLDrawableFactory, long l, int n, GLProfile gLProfile, AbstractGraphicsScreen abstractGraphicsScreen, boolean bl, boolean bl2) {
        AbstractGraphicsDevice abstractGraphicsDevice;
        WindowsWGLDrawableFactory windowsWGLDrawableFactory;
        WindowsWGLContext windowsWGLContext;
        if (gLDrawableFactory == null) {
            throw new GLException("Null factory");
        }
        if (l == 0L) {
            throw new GLException("Null HDC");
        }
        if (n <= 0) {
            throw new GLException("Invalid pixelformat id " + n);
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.getDefault(abstractGraphicsScreen.getDevice());
        }
        boolean bl3 = null != (windowsWGLContext = (WindowsWGLContext)(windowsWGLDrawableFactory = (WindowsWGLDrawableFactory)gLDrawableFactory).getOrCreateSharedContextImpl(abstractGraphicsDevice = abstractGraphicsScreen.getDevice())) && windowsWGLContext.isExtensionAvailable(WGL_ARB_pixel_format);
        WGLGLCapabilities wGLGLCapabilities = null;
        if (bl3) {
            wGLGLCapabilities = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(windowsWGLContext, l, n, gLProfile, bl, bl2);
        } else if (!bl2) {
            wGLGLCapabilities = WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(gLProfile, l, n, bl);
        }
        if (null == wGLGLCapabilities) {
            throw new GLException("Couldn't choose Capabilities by: HDC 0x" + Long.toHexString(l) + ", pfdID " + n + ", hasARB " + bl3);
        }
        return new WindowsWGLGraphicsConfiguration(abstractGraphicsScreen, wGLGLCapabilities, wGLGLCapabilities);
    }

    public Object clone() {
        return super.clone();
    }

    public final void updateGraphicsConfiguration(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface, int[] nArray) {
        WindowsWGLGraphicsConfigurationFactory.updateGraphicsConfiguration(this.chooser, gLDrawableFactory, nativeSurface, nArray);
    }

    public final void preselectGraphicsConfiguration(GLDrawableFactory gLDrawableFactory, int[] nArray) {
        AbstractGraphicsDevice abstractGraphicsDevice = this.getNativeGraphicsConfiguration().getScreen().getDevice();
        WindowsWGLGraphicsConfigurationFactory.preselectGraphicsConfiguration(this.chooser, gLDrawableFactory, abstractGraphicsDevice, this, nArray);
    }

    final void setCapsPFD(WGLGLCapabilities wGLGLCapabilities) {
        this.setChosenCapabilities(wGLGLCapabilities);
        this.isChosen = true;
        if (DEBUG) {
            System.err.println("*** setCapsPFD: " + wGLGLCapabilities);
        }
    }

    public final boolean isDetermined() {
        return this.isChosen;
    }

    public final PIXELFORMATDESCRIPTOR getPixelFormat() {
        return this.isChosen ? ((WGLGLCapabilities)this.capabilitiesChosen).getPFD() : null;
    }

    public final int getPixelFormatID() {
        return this.isChosen ? ((WGLGLCapabilities)this.capabilitiesChosen).getPFDID() : 0;
    }

    public final boolean isChoosenByARB() {
        return this.isChosen ? ((WGLGLCapabilities)this.capabilitiesChosen).isSetByARB() : false;
    }

    static int fillAttribsForGeneralWGLARBQuery(boolean bl, int[] nArray) {
        int n = 0;
        nArray[n++] = 8193;
        nArray[n++] = 8237;
        nArray[n++] = 8194;
        nArray[n++] = 8195;
        nArray[n++] = 8208;
        nArray[n++] = 8226;
        nArray[n++] = 8227;
        nArray[n++] = 8209;
        nArray[n++] = 8210;
        nArray[n++] = 8211;
        nArray[n++] = 8213;
        nArray[n++] = 8215;
        nArray[n++] = 8217;
        nArray[n++] = 8219;
        nArray[n++] = 8222;
        nArray[n++] = 8223;
        nArray[n++] = 8224;
        nArray[n++] = 8225;
        if (bl) {
            nArray[n++] = 8257;
            nArray[n++] = 8258;
        }
        nArray[n++] = 8211;
        nArray[n++] = 8368;
        return n;
    }

    static boolean wglARBPFIDValid(WindowsWGLContext windowsWGLContext, long l, int n) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        nArray[0] = 8212;
        if (!windowsWGLContext.getWGLExt().wglGetPixelFormatAttribivARB(l, n, 0, 1, nArray, 0, nArray2, 0)) {
            return GDI.GetLastError() == 0;
        }
        return true;
    }

    static int[] wglAllARBPFIDs(WindowsWGLContext windowsWGLContext, long l) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        WGLExt wGLExt = windowsWGLContext.getWGLExt();
        nArray[0] = 8192;
        if (!wGLExt.wglGetPixelFormatAttribivARB(l, 0, 0, 1, nArray, 0, nArray2, 0)) {
            if (DEBUG) {
                System.err.println("GetPixelFormatAttribivARB: Failed - HDC 0x" + Long.toHexString(l) + ", LastError: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        int n = nArray2[0];
        if (0 == n) {
            if (DEBUG) {
                System.err.println("GetPixelFormatAttribivARB: No formats - HDC 0x" + Long.toHexString(l) + ", LastError: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray3[i] = 1 + i;
        }
        return nArray3;
    }

    static WGLGLCapabilities wglARBPFID2GLCapabilities(WindowsWGLContext windowsWGLContext, long l, int n, GLProfile gLProfile, boolean bl, boolean bl2) {
        boolean bl3 = windowsWGLContext.isExtensionAvailable(WGL_ARB_pixel_format);
        if (!bl3) {
            return null;
        }
        boolean bl4 = windowsWGLContext.isExtensionAvailable(WGL_ARB_multisample);
        int[] nArray = new int[512];
        int[] nArray2 = new int[512];
        int n2 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(bl4, nArray);
        if (!windowsWGLContext.getWGLExt().wglGetPixelFormatAttribivARB(l, n, 0, n2, nArray, 0, nArray2, 0)) {
            throw new GLException("wglARBPFID2GLCapabilities: Error getting pixel format attributes for pixel format " + n + " of device context");
        }
        ArrayList arrayList = new ArrayList(1);
        int n3 = GLGraphicsConfigurationUtil.getWinAttributeBits(bl, bl2);
        if (WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(arrayList, gLProfile, l, n, nArray, n2, nArray2, n3)) {
            return (WGLGLCapabilities)arrayList.get(0);
        }
        return null;
    }

    static int[] wglChoosePixelFormatARB(long l, WindowsWGLContext windowsWGLContext, GLCapabilitiesImmutable gLCapabilitiesImmutable, int[] nArray, int n, float[] fArray) {
        if (!WindowsWGLGraphicsConfiguration.GLCapabilities2AttribList(gLCapabilitiesImmutable, nArray, windowsWGLContext, n, null)) {
            if (DEBUG) {
                System.err.println("wglChoosePixelFormatARB: GLCapabilities2AttribList failed: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[1];
        if (!windowsWGLContext.getWGLExt().wglChoosePixelFormatARB(l, nArray, 0, fArray, 0, 256, nArray2, 0, nArray3, 0)) {
            if (DEBUG) {
                System.err.println("wglChoosePixelFormatARB: wglChoosePixelFormatARB failed: " + GDI.GetLastError());
                Thread.dumpStack();
            }
            return null;
        }
        int n2 = nArray3[0];
        int[] nArray4 = null;
        if (0 < n2) {
            nArray4 = new int[n2];
            System.arraycopy(nArray2, 0, nArray4, 0, n2);
        }
        if (DEBUG) {
            System.err.println("wglChoosePixelFormatARB: NumFormats (wglChoosePixelFormatARB) accelMode 0x" + Integer.toHexString(n) + ": " + n2);
            for (int i = 0; i < n2; ++i) {
                WGLGLCapabilities wGLGLCapabilities = WindowsWGLGraphicsConfiguration.wglARBPFID2GLCapabilities(windowsWGLContext, l, nArray4[i], gLCapabilitiesImmutable.getGLProfile(), gLCapabilitiesImmutable.isOnscreen(), gLCapabilitiesImmutable.isPBuffer());
                System.err.println("pixel format " + nArray4[i] + " (index " + i + "): " + wGLGLCapabilities);
            }
        }
        return nArray4;
    }

    static List wglARBPFIDs2GLCapabilities(WindowsWGLContext windowsWGLContext, long l, int[] nArray, GLProfile gLProfile, boolean bl, boolean bl2) {
        int n = GLGraphicsConfigurationUtil.getWinAttributeBits(bl, bl2);
        return WindowsWGLGraphicsConfiguration.wglARBPFIDs2GLCapabilitiesImpl(windowsWGLContext, l, nArray, gLProfile, n);
    }

    static List wglARBPFIDs2AllGLCapabilities(WindowsWGLContext windowsWGLContext, long l, int[] nArray, GLProfile gLProfile) {
        return WindowsWGLGraphicsConfiguration.wglARBPFIDs2GLCapabilitiesImpl(windowsWGLContext, l, nArray, gLProfile, 7);
    }

    private static List wglARBPFIDs2GLCapabilitiesImpl(WindowsWGLContext windowsWGLContext, long l, int[] nArray, GLProfile gLProfile, int n) {
        boolean bl = windowsWGLContext.isExtensionAvailable(WGL_ARB_pixel_format);
        if (!bl) {
            return null;
        }
        boolean bl2 = windowsWGLContext.isExtensionAvailable(WGL_ARB_multisample);
        int n2 = nArray.length;
        int[] nArray2 = new int[512];
        int[] nArray3 = new int[512];
        int n3 = WindowsWGLGraphicsConfiguration.fillAttribsForGeneralWGLARBQuery(bl2, nArray2);
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] >= 1 && windowsWGLContext.getWGLExt().wglGetPixelFormatAttribivARB(l, nArray[i], 0, n3, nArray2, 0, nArray3, 0)) {
                WindowsWGLGraphicsConfiguration.AttribList2GLCapabilities(arrayList, gLProfile, l, nArray[i], nArray2, n3, nArray3, n);
                continue;
            }
            if (!DEBUG) continue;
            System.err.println("wglARBPFIDs2GLCapabilities: Cannot get pixel format attributes for pixel format " + i + "/" + n2 + ": " + nArray[i] + ", " + GLGraphicsConfigurationUtil.winAttributeBits2String(null, n).toString());
        }
        return arrayList;
    }

    static boolean GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable, int[] nArray, GLContextImpl gLContextImpl, int n, int[] nArray2) throws GLException {
        boolean bl = gLContextImpl.isExtensionAvailable(WGL_ARB_pixel_format);
        boolean bl2 = gLContextImpl.isExtensionAvailable(WGL_ARB_multisample);
        if (DEBUG) {
            System.err.println("HDC2GLCapabilities: ARB_pixel_format: " + bl);
            System.err.println("HDC2GLCapabilities: ARB_multisample : " + bl2);
        }
        if (!bl) {
            return false;
        }
        boolean bl3 = gLCapabilitiesImmutable.isOnscreen();
        boolean bl4 = gLCapabilitiesImmutable.isPBuffer();
        int n2 = 0;
        nArray[n2++] = 8208;
        nArray[n2++] = 1;
        if (n > 0) {
            nArray[n2++] = 8195;
            nArray[n2++] = n;
        }
        if (bl3) {
            nArray[n2++] = 8193;
            nArray[n2++] = 1;
        } else if (bl4) {
            nArray[n2++] = 8237;
            nArray[n2++] = 1;
        } else {
            nArray[n2++] = 8194;
            nArray[n2++] = 1;
        }
        nArray[n2++] = 8209;
        nArray[n2++] = gLCapabilitiesImmutable.getDoubleBuffered() ? 1 : 0;
        nArray[n2++] = 8210;
        nArray[n2++] = gLCapabilitiesImmutable.getStereo() ? 1 : 0;
        nArray[n2++] = 8226;
        nArray[n2++] = gLCapabilitiesImmutable.getDepthBits();
        nArray[n2++] = 8213;
        nArray[n2++] = gLCapabilitiesImmutable.getRedBits();
        nArray[n2++] = 8215;
        nArray[n2++] = gLCapabilitiesImmutable.getGreenBits();
        nArray[n2++] = 8217;
        nArray[n2++] = gLCapabilitiesImmutable.getBlueBits();
        nArray[n2++] = 8219;
        nArray[n2++] = gLCapabilitiesImmutable.getAlphaBits();
        nArray[n2++] = 8227;
        nArray[n2++] = gLCapabilitiesImmutable.getStencilBits();
        if (gLCapabilitiesImmutable.getAccumRedBits() > 0 || gLCapabilitiesImmutable.getAccumGreenBits() > 0 || gLCapabilitiesImmutable.getAccumBlueBits() > 0 || gLCapabilitiesImmutable.getAccumAlphaBits() > 0) {
            nArray[n2++] = 8221;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits() + gLCapabilitiesImmutable.getAccumAlphaBits();
            nArray[n2++] = 8222;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumRedBits();
            nArray[n2++] = 8223;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumGreenBits();
            nArray[n2++] = 8224;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumBlueBits();
            nArray[n2++] = 8225;
            nArray[n2++] = gLCapabilitiesImmutable.getAccumAlphaBits();
        }
        if (gLCapabilitiesImmutable.getSampleBuffers() && bl2) {
            nArray[n2++] = 8257;
            nArray[n2++] = 1;
            nArray[n2++] = 8258;
            nArray[n2++] = gLCapabilitiesImmutable.getNumSamples();
        }
        boolean bl5 = gLCapabilitiesImmutable.getPbufferRenderToTexture();
        boolean bl6 = gLCapabilitiesImmutable.getPbufferRenderToTextureRectangle();
        boolean bl7 = gLCapabilitiesImmutable.getPbufferFloatingPointBuffers();
        boolean bl8 = false;
        if (bl4) {
            if (bl6 && !bl5) {
                throw new GLException("Render-to-texture-rectangle requires render-to-texture to be specified");
            }
            if (bl6 && !gLContextImpl.isExtensionAvailable("GL_NV_texture_rectangle")) {
                throw new GLException("Render-to-texture-rectangle requires GL_NV_texture_rectangle extension");
            }
            if (bl7) {
                if (!gLContextImpl.isExtensionAvailable("WGL_ATI_pixel_format_float") && !gLContextImpl.isExtensionAvailable("WGL_NV_float_buffer")) {
                    throw new GLException("Floating-point pbuffers not supported by this hardware");
                }
                if (gLContextImpl.isExtensionAvailable("WGL_NV_float_buffer")) {
                    bl8 = false;
                    nArray2[0] = 3;
                } else {
                    bl8 = true;
                    nArray2[0] = 2;
                }
                if (DEBUG) {
                    System.err.println("Using " + (bl8 ? "ATI" : "NVidia") + " floating-point extension");
                }
            }
            if (bl7 && bl8) {
                if (bl5) {
                    throw new GLException("Render-to-floating-point-texture not supported on ATI hardware");
                }
                nArray[n2++] = 8211;
                nArray[n2++] = 8608;
            } else if (!bl5) {
                nArray[n2++] = 8211;
                nArray[n2++] = 8235;
            }
            if (bl7 && !bl8) {
                nArray[n2++] = 8368;
                nArray[n2++] = 1;
            }
            if (bl5) {
                if (bl7) {
                    assert (!bl8);
                    if (!bl6) {
                        throw new GLException("Render-to-floating-point-texture only supported on NVidia hardware with render-to-texture-rectangle");
                    }
                    nArray[n2++] = 8371;
                    nArray[n2++] = 1;
                } else {
                    nArray[n2++] = bl6 ? 8352 : 8304;
                    nArray[n2++] = 1;
                }
            }
        } else {
            nArray[n2++] = 8211;
            nArray[n2++] = 8235;
        }
        nArray[n2++] = 0;
        return true;
    }

    static int AttribList2DrawableTypeBits(int[] nArray, int n, int[] nArray2) {
        int n2 = 0;
        block5: for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            switch (n3) {
                case 8193: {
                    if (nArray2[i] != 1) continue block5;
                    n2 |= 1;
                    continue block5;
                }
                case 8194: {
                    if (nArray2[i] != 1) continue block5;
                    n2 |= 2;
                    continue block5;
                }
                case 8237: {
                    if (nArray2[i] != 1) continue block5;
                    n2 |= 4;
                }
            }
        }
        return n2;
    }

    static boolean AttribList2GLCapabilities(ArrayList arrayList, GLProfile gLProfile, long l, int n, int[] nArray, int n2, int[] nArray2, int n3) {
        int n4 = WindowsWGLGraphicsConfiguration.AttribList2DrawableTypeBits(nArray, n2, nArray2);
        int n5 = n3 & n4;
        if (0 == n5) {
            return false;
        }
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor();
        if (GDI.DescribePixelFormat((long)l, (int)n, (int)pIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR) == 0 && 0 == (n5 &= 0xFFFFFFFC)) {
            return false;
        }
        WGLGLCapabilities wGLGLCapabilities = new WGLGLCapabilities(pIXELFORMATDESCRIPTOR, n, gLProfile);
        wGLGLCapabilities.setValuesByARB(nArray, n2, nArray2);
        return GLGraphicsConfigurationUtil.addGLCapabilitiesPermutations(arrayList, wGLGLCapabilities, n5);
    }

    static int[] wglAllGDIPFIDs(long l) {
        int n = GDI.DescribePixelFormat((long)l, (int)1, (int)0, null);
        if (n == 0) {
            throw new GLException("DescribePixelFormat: No formats - HDC 0x" + Long.toHexString(l) + ", LastError: " + GDI.GetLastError());
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = 1 + i;
        }
        return nArray;
    }

    static int PFD2DrawableTypeBits(PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        int n = 0;
        int n2 = pIXELFORMATDESCRIPTOR.getDwFlags();
        if (0 != (4 & n2)) {
            n |= 1;
        }
        if (0 != (8 & n2)) {
            n |= 2;
        }
        return n;
    }

    static WGLGLCapabilities PFD2GLCapabilities(GLProfile gLProfile, long l, int n, boolean bl) {
        ArrayList arrayList = new ArrayList(1);
        int n2 = GLGraphicsConfigurationUtil.getWinAttributeBits(bl, false);
        if (WindowsWGLGraphicsConfiguration.PFD2GLCapabilities(arrayList, gLProfile, l, n, n2)) {
            return (WGLGLCapabilities)arrayList.get(0);
        }
        return null;
    }

    static boolean PFD2GLCapabilities(ArrayList arrayList, GLProfile gLProfile, long l, int n, int n2) {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor(l, n);
        if (null == pIXELFORMATDESCRIPTOR) {
            return false;
        }
        if ((pIXELFORMATDESCRIPTOR.getDwFlags() & 0x20) == 0) {
            return false;
        }
        int n3 = WindowsWGLGraphicsConfiguration.PFD2DrawableTypeBits(pIXELFORMATDESCRIPTOR);
        int n4 = n2 & n3;
        if (0 == n4) {
            return false;
        }
        WGLGLCapabilities wGLGLCapabilities = new WGLGLCapabilities(pIXELFORMATDESCRIPTOR, n, gLProfile);
        wGLGLCapabilities.setValuesByGDI();
        return GLGraphicsConfigurationUtil.addGLCapabilitiesPermutations(arrayList, wGLGLCapabilities, n4);
    }

    static PIXELFORMATDESCRIPTOR GLCapabilities2PFD(GLCapabilitiesImmutable gLCapabilitiesImmutable, PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR) {
        int n = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        if (n < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        int n2 = 4128;
        if (gLCapabilitiesImmutable.getDoubleBuffered()) {
            n2 |= 1;
        }
        n2 = gLCapabilitiesImmutable.isOnscreen() ? (n2 |= 4) : (n2 |= 8);
        if (gLCapabilitiesImmutable.getStereo()) {
            n2 |= 2;
        }
        pIXELFORMATDESCRIPTOR.setDwFlags(n2);
        pIXELFORMATDESCRIPTOR.setIPixelType((byte)0);
        pIXELFORMATDESCRIPTOR.setCColorBits((byte)n);
        pIXELFORMATDESCRIPTOR.setCRedBits((byte)gLCapabilitiesImmutable.getRedBits());
        pIXELFORMATDESCRIPTOR.setCGreenBits((byte)gLCapabilitiesImmutable.getGreenBits());
        pIXELFORMATDESCRIPTOR.setCBlueBits((byte)gLCapabilitiesImmutable.getBlueBits());
        pIXELFORMATDESCRIPTOR.setCAlphaBits((byte)gLCapabilitiesImmutable.getAlphaBits());
        int n3 = gLCapabilitiesImmutable.getAccumRedBits() + gLCapabilitiesImmutable.getAccumGreenBits() + gLCapabilitiesImmutable.getAccumBlueBits();
        pIXELFORMATDESCRIPTOR.setCAccumBits((byte)n3);
        pIXELFORMATDESCRIPTOR.setCAccumRedBits((byte)gLCapabilitiesImmutable.getAccumRedBits());
        pIXELFORMATDESCRIPTOR.setCAccumGreenBits((byte)gLCapabilitiesImmutable.getAccumGreenBits());
        pIXELFORMATDESCRIPTOR.setCAccumBlueBits((byte)gLCapabilitiesImmutable.getAccumBlueBits());
        pIXELFORMATDESCRIPTOR.setCAccumAlphaBits((byte)gLCapabilitiesImmutable.getAccumAlphaBits());
        pIXELFORMATDESCRIPTOR.setCDepthBits((byte)gLCapabilitiesImmutable.getDepthBits());
        pIXELFORMATDESCRIPTOR.setCStencilBits((byte)gLCapabilitiesImmutable.getStencilBits());
        pIXELFORMATDESCRIPTOR.setILayerType((byte)0);
        return pIXELFORMATDESCRIPTOR;
    }

    static PIXELFORMATDESCRIPTOR createPixelFormatDescriptor(long l, int n) {
        PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = PIXELFORMATDESCRIPTOR.create();
        pIXELFORMATDESCRIPTOR.setNSize((short)pIXELFORMATDESCRIPTOR.size());
        pIXELFORMATDESCRIPTOR.setNVersion((short)1);
        if (0L != l && 1 <= n) {
            if (GDI.DescribePixelFormat((long)l, (int)n, (int)pIXELFORMATDESCRIPTOR.size(), (PIXELFORMATDESCRIPTOR)pIXELFORMATDESCRIPTOR) == 0) {
                if (DEBUG) {
                    System.err.println("Info: Non displayable pixel format " + n + " of device context: error code " + GDI.GetLastError());
                }
                return null;
            }
        }
        return pIXELFORMATDESCRIPTOR;
    }

    static PIXELFORMATDESCRIPTOR createPixelFormatDescriptor() {
        return WindowsWGLGraphicsConfiguration.createPixelFormatDescriptor(0L, 0);
    }

    public String toString() {
        return "WindowsWGLGraphicsConfiguration[" + this.getScreen() + ", pfdID " + this.getPixelFormatID() + ", ARB-Choosen " + this.isChoosenByARB() + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

