/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.x11.X11GraphicsDevice;
import javax.media.nativewindow.x11.X11GraphicsScreen;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.ProxySurface;
import jogamp.nativewindow.x11.X11Util;
import jogamp.opengl.DesktopGLDynamicLookupHelper;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableFactoryImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLDynamicLookupHelper;
import jogamp.opengl.SharedResourceRunner;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.GLXUtil;
import jogamp.opengl.x11.glx.X11DummyGLXDrawable;
import jogamp.opengl.x11.glx.X11ExternalGLXContext;
import jogamp.opengl.x11.glx.X11ExternalGLXDrawable;
import jogamp.opengl.x11.glx.X11GLXContext;
import jogamp.opengl.x11.glx.X11GLXDynamicLibraryBundleInfo;
import jogamp.opengl.x11.glx.X11GLXGraphicsConfigurationFactory;
import jogamp.opengl.x11.glx.X11OnscreenGLXDrawable;
import jogamp.opengl.x11.glx.X11PbufferGLXDrawable;
import jogamp.opengl.x11.glx.X11PixmapGLXDrawable;

public class X11GLXDrawableFactory
extends GLDrawableFactoryImpl {
    private static final DesktopGLDynamicLookupHelper x11GLXDynamicLookupHelper;
    static final VersionNumber versionOneThree;
    X11GraphicsDevice defaultDevice;
    SharedResourceImplementation sharedResourceImpl;
    SharedResourceRunner sharedResourceRunner;
    Thread sharedResourceThread;
    HashMap sharedMap = new HashMap();
    private boolean gotGammaRampLength;
    private int gammaRampLength;

    public static VersionNumber getGLXVersion(X11GraphicsDevice x11GraphicsDevice) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        GLXUtil.getGLXVersion(x11GraphicsDevice.getHandle(), nArray, nArray2);
        return new VersionNumber(nArray[0], nArray2[0], 0);
    }

    @Override
    public GLDynamicLookupHelper getGLDynamicLookupHelper(int n) {
        return x11GLXDynamicLookupHelper;
    }

    public X11GLXDrawableFactory() {
        new X11GLXGraphicsConfigurationFactory();
        if (GLProfile.isAWTAvailable()) {
            try {
                ReflectionUtil.createInstance((String)"jogamp.opengl.x11.glx.awt.X11AWTGLXGraphicsConfigurationFactory", null, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (JogampRuntimeException jogampRuntimeException) {
                // empty catch block
            }
        }
        this.defaultDevice = new X11GraphicsDevice(X11Util.getNullDisplayName(), 0);
        this.sharedResourceImpl = new SharedResourceImplementation();
        this.sharedResourceRunner = new SharedResourceRunner(this.sharedResourceImpl);
        this.sharedResourceThread = new Thread((Runnable)this.sharedResourceRunner, Thread.currentThread().getName() + "-SharedResourceRunner");
        this.sharedResourceThread.setDaemon(true);
        this.sharedResourceThread.start();
    }

    @Override
    public final AbstractGraphicsDevice getDefaultDevice() {
        return this.defaultDevice;
    }

    @Override
    public final boolean getIsDeviceCompatible(AbstractGraphicsDevice abstractGraphicsDevice) {
        return abstractGraphicsDevice instanceof X11GraphicsDevice;
    }

    @Override
    protected final GLContext getOrCreateSharedContextImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getContext();
        }
        return null;
    }

    @Override
    protected AbstractGraphicsDevice getOrCreateSharedDeviceImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getDevice();
        }
        return null;
    }

    protected final long getOrCreateSharedDpy(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return resource.getDevice().getHandle();
        }
        return 0L;
    }

    SharedResource getOrCreateSharedResource(AbstractGraphicsDevice abstractGraphicsDevice) {
        return (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
    }

    public final String getGLXVendorName(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return ((SharedResource)resource).getGLXVendorName();
        }
        return GLXUtil.getVendorName(abstractGraphicsDevice.getHandle());
    }

    public final boolean isGLXVendorATI(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return ((SharedResource)resource).isGLXVendorATI();
        }
        return GLXUtil.isVendorATI(abstractGraphicsDevice.getHandle());
    }

    public final boolean isGLXVendorNVIDIA(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            return ((SharedResource)resource).isGLXVendorNVIDIA();
        }
        return GLXUtil.isVendorNVIDIA(abstractGraphicsDevice.getHandle());
    }

    @Override
    protected final void shutdownInstance() {
        this.sharedResourceRunner.releaseAndWait();
        X11Util.shutdown((boolean)false, (boolean)DEBUG);
    }

    @Override
    protected List getAvailableCapabilitiesImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        return X11GLXGraphicsConfigurationFactory.getAvailableCapabilities(this, abstractGraphicsDevice);
    }

    @Override
    protected final GLDrawableImpl createOnscreenDrawableImpl(NativeSurface nativeSurface) {
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        return new X11OnscreenGLXDrawable(this, nativeSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final GLDrawableImpl createOffscreenDrawableImpl(NativeSurface nativeSurface) {
        X11PbufferGLXDrawable x11PbufferGLXDrawable;
        if (nativeSurface == null) {
            throw new IllegalArgumentException("Null target");
        }
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = nativeSurface.getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)abstractGraphicsConfiguration.getChosenCapabilities();
        if (!gLCapabilitiesImmutable.isPBuffer()) {
            return new X11PixmapGLXDrawable(this, nativeSurface);
        }
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != sharedResource && sharedResource.isGLXVendorATI() && null == GLContext.getCurrent()) {
            sharedResource.getContext().makeCurrent();
            try {
                x11PbufferGLXDrawable = new X11PbufferGLXDrawable(this, nativeSurface);
            }
            finally {
                sharedResource.getContext().release();
            }
        } else {
            x11PbufferGLXDrawable = new X11PbufferGLXDrawable(this, nativeSurface);
        }
        return x11PbufferGLXDrawable;
    }

    public final boolean isGLXVersionGreaterEqualOneThree(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResource sharedResource = (SharedResource)this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != sharedResource) {
            return sharedResource.isGLXVersionGreaterEqualOneThree();
        }
        if (abstractGraphicsDevice instanceof X11GraphicsDevice) {
            VersionNumber versionNumber = X11GLXDrawableFactory.getGLXVersion((X11GraphicsDevice)abstractGraphicsDevice);
            return null != versionNumber ? versionNumber.compareTo((Object)versionOneThree) >= 0 : false;
        }
        return false;
    }

    @Override
    public final boolean canCreateGLPbuffer(AbstractGraphicsDevice abstractGraphicsDevice) {
        SharedResourceRunner.Resource resource;
        if (null == abstractGraphicsDevice && null != (resource = this.sharedResourceRunner.getOrCreateShared((AbstractGraphicsDevice)this.defaultDevice))) {
            abstractGraphicsDevice = resource.getDevice();
        }
        return this.isGLXVersionGreaterEqualOneThree(abstractGraphicsDevice);
    }

    @Override
    protected final NativeSurface createOffscreenSurfaceImpl(AbstractGraphicsDevice abstractGraphicsDevice, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesChooser gLCapabilitiesChooser, int n, int n2) {
        X11GraphicsScreen x11GraphicsScreen = null;
        SharedResourceRunner.Resource resource = this.sharedResourceRunner.getOrCreateShared(abstractGraphicsDevice);
        if (null != resource) {
            x11GraphicsScreen = (X11GraphicsScreen)resource.getScreen();
        }
        if (null == x11GraphicsScreen) {
            return null;
        }
        ProxySurface proxySurface = new ProxySurface((AbstractGraphicsConfiguration)X11GLXGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable2, gLCapabilitiesChooser, x11GraphicsScreen));
        if (proxySurface != null) {
            proxySurface.setSize(n, n2);
        }
        return proxySurface;
    }

    @Override
    protected final GLContext createExternalGLContextImpl() {
        return X11ExternalGLXContext.create(this, null);
    }

    @Override
    public final boolean canCreateExternalGLDrawable(AbstractGraphicsDevice abstractGraphicsDevice) {
        return this.canCreateGLPbuffer(abstractGraphicsDevice);
    }

    @Override
    protected final GLDrawable createExternalGLDrawableImpl() {
        return X11ExternalGLXDrawable.create(this, null);
    }

    @Override
    public final boolean canCreateContextOnJava2DSurface(AbstractGraphicsDevice abstractGraphicsDevice) {
        return false;
    }

    @Override
    public final GLContext createContextOnJava2DSurface(Object object, GLContext gLContext) throws GLException {
        throw new GLException("Unimplemented on this platform");
    }

    @Override
    protected final synchronized int getGammaRampLength() {
        if (this.gotGammaRampLength) {
            return this.gammaRampLength;
        }
        long l = this.getOrCreateSharedDpy((AbstractGraphicsDevice)this.defaultDevice);
        if (0L == l) {
            return 0;
        }
        int[] nArray = new int[1];
        boolean bl = X11Util.XF86VidModeGetGammaRampSize((long)l, (int)X11Util.DefaultScreen((long)l), (int[])nArray, (int)0);
        if (!bl) {
            return 0;
        }
        this.gotGammaRampLength = true;
        this.gammaRampLength = nArray[0];
        return this.gammaRampLength;
    }

    @Override
    protected final boolean setGammaRamp(float[] fArray) {
        int n;
        long l = this.getOrCreateSharedDpy((AbstractGraphicsDevice)this.defaultDevice);
        if (0L == l) {
            return false;
        }
        int n2 = fArray.length;
        short[] sArray = new short[n2];
        for (n = 0; n < n2; n += 1) {
            sArray[n] = (short)(fArray[n] * 65535.0f);
        }
        n = X11Util.XF86VidModeSetGammaRamp((long)l, (int)X11Util.DefaultScreen((long)l), (int)sArray.length, (short[])sArray, (int)0, (short[])sArray, (int)0, (short[])sArray, (int)0) ? 1 : 0;
        return n != 0;
    }

    @Override
    protected final Buffer getGammaRamp() {
        long l = this.getOrCreateSharedDpy((AbstractGraphicsDevice)this.defaultDevice);
        if (0L == l) {
            return null;
        }
        int n = this.getGammaRampLength();
        ShortBuffer shortBuffer = ShortBuffer.wrap(new short[3 * n]);
        shortBuffer.position(0);
        shortBuffer.limit(n);
        ShortBuffer shortBuffer2 = shortBuffer.slice();
        shortBuffer.position(n);
        shortBuffer.limit(2 * n);
        ShortBuffer shortBuffer3 = shortBuffer.slice();
        shortBuffer.position(2 * n);
        shortBuffer.limit(3 * n);
        ShortBuffer shortBuffer4 = shortBuffer.slice();
        boolean bl = X11Util.XF86VidModeGetGammaRamp((long)l, (int)X11Util.DefaultScreen((long)l), (int)n, (ShortBuffer)shortBuffer2, (ShortBuffer)shortBuffer3, (ShortBuffer)shortBuffer4);
        if (!bl) {
            return null;
        }
        return shortBuffer;
    }

    @Override
    protected final void resetGammaRamp(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        long l = this.getOrCreateSharedDpy((AbstractGraphicsDevice)this.defaultDevice);
        if (0L == l) {
            return;
        }
        ShortBuffer shortBuffer = (ShortBuffer)buffer;
        int n = shortBuffer.capacity();
        if (n % 3 != 0) {
            throw new IllegalArgumentException("Must not be the original gamma ramp");
        }
        int n2 = n / 3;
        shortBuffer.position(0);
        shortBuffer.limit(n2);
        ShortBuffer shortBuffer2 = shortBuffer.slice();
        shortBuffer.position(n2);
        shortBuffer.limit(2 * n2);
        ShortBuffer shortBuffer3 = shortBuffer.slice();
        shortBuffer.position(2 * n2);
        shortBuffer.limit(3 * n2);
        ShortBuffer shortBuffer4 = shortBuffer.slice();
        X11Util.XF86VidModeSetGammaRamp((long)l, (int)X11Util.DefaultScreen((long)l), (int)n2, (ShortBuffer)shortBuffer2, (ShortBuffer)shortBuffer3, (ShortBuffer)shortBuffer4);
    }

    static {
        DesktopGLDynamicLookupHelper desktopGLDynamicLookupHelper;
        block3: {
            versionOneThree = new VersionNumber(1, 3, 0);
            desktopGLDynamicLookupHelper = null;
            try {
                desktopGLDynamicLookupHelper = new DesktopGLDynamicLookupHelper(new X11GLXDynamicLibraryBundleInfo());
            }
            catch (GLException gLException) {
                if (!DEBUG) break block3;
                gLException.printStackTrace();
            }
        }
        x11GLXDynamicLookupHelper = desktopGLDynamicLookupHelper;
        if (null != x11GLXDynamicLookupHelper) {
            GLX.getGLXProcAddressTable().reset((DynamicLookupHelper)x11GLXDynamicLookupHelper);
        }
    }

    class SharedResourceImplementation
    implements SharedResourceRunner.Implementation {
        SharedResourceImplementation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            HashMap hashMap = X11GLXDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                X11GLXDrawableFactory.this.sharedMap.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedResourceRunner.Resource mapPut(String string, SharedResourceRunner.Resource resource) {
            HashMap hashMap = X11GLXDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return X11GLXDrawableFactory.this.sharedMap.put(string, resource);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedResourceRunner.Resource mapGet(String string) {
            HashMap hashMap = X11GLXDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return (SharedResourceRunner.Resource)X11GLXDrawableFactory.this.sharedMap.get(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection mapValues() {
            HashMap hashMap = X11GLXDrawableFactory.this.sharedMap;
            synchronized (hashMap) {
                return X11GLXDrawableFactory.this.sharedMap.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SharedResourceRunner.Resource createSharedResource(String string) {
            X11GraphicsDevice x11GraphicsDevice = new X11GraphicsDevice(X11Util.createDisplay((String)string), 0);
            x11GraphicsDevice.setCloseDisplay(true);
            x11GraphicsDevice.lock();
            try {
                String string2 = GLXUtil.getVendorName(x11GraphicsDevice.getHandle());
                X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(x11GraphicsDevice, 0);
                if (null == x11GraphicsScreen) {
                    throw new GLException("Couldn't create shared screen for device: " + x11GraphicsDevice + ", idx 0");
                }
                GLProfile gLProfile = GLProfile.getMinDesktop((AbstractGraphicsDevice)x11GraphicsDevice);
                if (null == gLProfile) {
                    throw new GLException("Couldn't get default GLProfile for device: " + x11GraphicsDevice);
                }
                X11DummyGLXDrawable x11DummyGLXDrawable = X11DummyGLXDrawable.create(x11GraphicsScreen, X11GLXDrawableFactory.this, gLProfile);
                if (null == x11DummyGLXDrawable) {
                    throw new GLException("Couldn't create shared drawable for screen: " + x11GraphicsScreen + ", " + gLProfile);
                }
                X11GLXContext x11GLXContext = (X11GLXContext)x11DummyGLXDrawable.createContext(null);
                if (null == x11GLXContext) {
                    throw new GLException("Couldn't create shared context for drawable: " + x11DummyGLXDrawable);
                }
                x11GLXContext.setSynchronized(true);
                VersionNumber versionNumber = X11GLXDrawableFactory.getGLXVersion(x11GraphicsDevice);
                boolean bl = false;
                x11GLXContext.makeCurrent();
                try {
                    bl = x11GLXContext.isCurrent();
                }
                finally {
                    x11GLXContext.release();
                }
                if (DEBUG) {
                    System.err.println("!!! SharedDevice:  " + x11GraphicsDevice);
                    System.err.println("!!! SharedScreen:  " + x11GraphicsScreen);
                    System.err.println("!!! SharedContext: " + x11GLXContext + ", madeCurrent " + bl);
                    System.err.println("!!! GLX Vendor:    " + string2);
                    System.err.println("!!! GLX Version:   " + versionNumber + " >= 1.3: " + (versionNumber.compareTo((Object)versionOneThree) >= 0));
                }
                SharedResource sharedResource = new SharedResource(x11GraphicsDevice, x11GraphicsScreen, x11DummyGLXDrawable, x11GLXContext, versionNumber, string2);
                return sharedResource;
            }
            catch (Throwable throwable) {
                throw new GLException("WindowsWGLDrawableFactory - Could not initialize shared resources for " + string, throwable);
            }
            finally {
                x11GraphicsDevice.unlock();
            }
        }

        @Override
        public void releaseSharedResource(SharedResourceRunner.Resource resource) {
            SharedResource sharedResource = (SharedResource)resource;
            if (DEBUG) {
                System.err.println("!!! Shutdown Shared:");
                System.err.println("!!!   Device  : " + sharedResource.device);
                System.err.println("!!!   Screen  : " + sharedResource.screen);
                System.err.println("!!!   Drawable: " + sharedResource.drawable);
                System.err.println("!!!   CTX     : " + sharedResource.context);
            }
            if (null != sharedResource.context) {
                sharedResource.context = null;
            }
            if (null != sharedResource.drawable) {
                sharedResource.drawable = null;
            }
            if (null != sharedResource.screen) {
                sharedResource.screen = null;
            }
            if (null != sharedResource.device) {
                sharedResource.device.close();
                sharedResource.device = null;
            }
        }
    }

    static class SharedResource
    implements SharedResourceRunner.Resource {
        X11GraphicsDevice device;
        X11GraphicsScreen screen;
        X11DummyGLXDrawable drawable;
        X11GLXContext context;
        String glXVendorName;
        boolean isGLXVendorATI;
        boolean isGLXVendorNVIDIA;
        VersionNumber glXVersion;

        SharedResource(X11GraphicsDevice x11GraphicsDevice, X11GraphicsScreen x11GraphicsScreen, X11DummyGLXDrawable x11DummyGLXDrawable, X11GLXContext x11GLXContext, VersionNumber versionNumber, String string) {
            this.device = x11GraphicsDevice;
            this.screen = x11GraphicsScreen;
            this.drawable = x11DummyGLXDrawable;
            this.context = x11GLXContext;
            this.glXVersion = versionNumber;
            this.glXVendorName = string;
            this.isGLXVendorATI = GLXUtil.isVendorATI(this.glXVendorName);
            this.isGLXVendorNVIDIA = GLXUtil.isVendorNVIDIA(this.glXVendorName);
        }

        @Override
        public final AbstractGraphicsDevice getDevice() {
            return this.device;
        }

        @Override
        public final AbstractGraphicsScreen getScreen() {
            return this.screen;
        }

        @Override
        public final GLDrawableImpl getDrawable() {
            return this.drawable;
        }

        @Override
        public final GLContextImpl getContext() {
            return this.context;
        }

        final String getGLXVendorName() {
            return this.glXVendorName;
        }

        final boolean isGLXVendorATI() {
            return this.isGLXVendorATI;
        }

        final boolean isGLXVendorNVIDIA() {
            return this.isGLXVendorNVIDIA;
        }

        final VersionNumber getGLXVersion() {
            return this.glXVersion;
        }

        final boolean isGLXVersionGreaterEqualOneThree() {
            return null != this.glXVersion ? this.glXVersion.compareTo((Object)versionOneThree) >= 0 : false;
        }
    }
}

