/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.checkbox;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class CheckboxControl
implements Controller {
    private Element element;
    private Screen screen;
    private boolean checked;
    private FocusHandler focusHandler;

    public void bind(Nifty niftyParam, Screen screenParam, Element elementParam, Properties propertiesParam, ControllerEventListener listenerParam, Attributes controlDefinitionAttributes) {
        this.element = elementParam;
        this.screen = screenParam;
        this.checked = new Boolean(propertiesParam.getProperty("checked", "true"));
        this.updateVisualState();
    }

    public void onStartScreen() {
        this.focusHandler = this.screen.getFocusHandler();
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyInputEvent.NextInputElement) {
            this.focusHandler.getNext(this.element).setFocus();
            return true;
        }
        if (inputEvent == NiftyInputEvent.PrevInputElement) {
            this.focusHandler.getPrev(this.element).setFocus();
            return true;
        }
        if (inputEvent == NiftyInputEvent.Activate) {
            this.onClick();
            return true;
        }
        return false;
    }

    public boolean onClick() {
        this.checked = !this.checked;
        this.updateVisualState();
        return true;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void check() {
        this.checked = true;
        this.updateVisualState();
    }

    public void uncheck() {
        this.checked = false;
        this.updateVisualState();
    }

    public void setChecked(boolean state) {
        this.checked = state;
        this.updateVisualState();
    }

    private void updateVisualState() {
        Element selectImage = this.element.findElementByName("select");
        if (this.checked) {
            selectImage.stopEffect(EffectEventId.onCustom);
            selectImage.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                }
            }, "show");
        } else {
            selectImage.stopEffect(EffectEventId.onCustom);
            selectImage.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                }
            }, "hide");
        }
    }
}

