/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollbar.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.NextPrevHelper;
import de.lessvoid.nifty.controls.scrollbar.controller.ScrollbarControlNotify;
import de.lessvoid.nifty.controls.scrollbar.controller.impl.ScrollBarImpl;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class GeneralScrollbar
implements Controller {
    private Screen screen;
    private Element element;
    private ControllerEventListener listener;
    private Element scrollPos;
    private float viewMinValue;
    private float viewMaxValue;
    private float currentValue;
    private float worldMinValue;
    private float worldMaxValue;
    private float perClickChange = 1.0f;
    private int startMouse;
    private float pageSize;
    private ScrollBarImpl scrollBar;
    private NextPrevHelper nextPrevHelper;

    public void setScrollBarControlNotify(final ScrollbarControlNotify scrollBarControlNotifyParam) {
        this.listener = new ControllerEventListener(){

            public void onChangeNotify() {
                scrollBarControlNotifyParam.positionChanged(GeneralScrollbar.this.currentValue);
            }
        };
    }

    public GeneralScrollbar(ScrollBarImpl scrollBarImplParam) {
        this.scrollBar = scrollBarImplParam;
    }

    public void bind(Nifty newNifty, Screen screenParam, Element newElement, Properties properties, ControllerEventListener newListener, Attributes controlDefinitionAttributes) {
        this.element = newElement;
        this.screen = screenParam;
        this.listener = newListener;
        this.viewMinValue = Float.parseFloat(properties.getProperty("viewMinValue", "0.0"));
        this.viewMaxValue = Float.parseFloat(properties.getProperty("viewMaxValue", "1.0"));
        this.worldMinValue = Float.parseFloat(properties.getProperty("worldMinValue", "0.0"));
        this.worldMaxValue = Float.parseFloat(properties.getProperty("worldMaxValue", "1.0"));
        this.currentValue = Float.parseFloat(properties.getProperty("currentValue", "0.0"));
        this.scrollPos = this.element.findElementByName("nifty-internal-scrollbar-position");
        this.element = this.element.findElementByName("nifty-internal-scrollbar-background");
        this.nextPrevHelper = new NextPrevHelper(this.element, this.screen.getFocusHandler());
    }

    public void onStartScreen() {
        this.calcPageSize();
        this.changeSliderPos(this.currentValue);
    }

    private void calcPageSize() {
        float worldSize = this.worldMaxValue - this.worldMinValue;
        float pages = worldSize / (this.viewMaxValue - this.viewMinValue);
        if (pages < 1.0f) {
            pages = 1.0f;
        }
        this.pageSize = worldSize / pages;
        this.scrollBar.resizeHandle(this.scrollPos, new SizeValue((int)((float)this.scrollBar.translateValue(this.element.getWidth(), this.element.getHeight()) / pages) + "px"));
        Element parent = this.scrollPos.getParent();
        if (parent != null) {
            parent.layoutElements();
        }
    }

    public void click(int mouseX, int mouseY) {
        int scrollSize;
        int scrollValue;
        int mouseValue = this.scrollBar.translateValue(mouseX, mouseY);
        if (mouseValue < (scrollValue = this.scrollBar.translateValue(this.scrollPos.getX(), this.scrollPos.getY()))) {
            this.changeSliderPos(this.currentValue - this.pageSize);
        }
        if (mouseValue > scrollValue + (scrollSize = this.scrollBar.translateValue(this.scrollPos.getWidth(), this.scrollPos.getHeight()))) {
            this.changeSliderPos(this.currentValue + this.pageSize);
        }
    }

    public void mouseMoveStart(int mouseX, int mouseY) {
        this.startMouse = this.scrollBar.translateValue(mouseX, mouseY) - this.scrollBar.translateValue(this.scrollPos.getX(), this.scrollPos.getY());
    }

    public void mouseMove(int mouseX, int mouseY) {
        this.changeSliderPosFromMouse(mouseX, mouseY);
    }

    public void upClick(int mouseX, int mouseY) {
        this.currentValue -= this.perClickChange;
        this.changeSliderPos(this.currentValue);
    }

    public void downClick(int mouseX, int mouseY) {
        this.currentValue += this.perClickChange;
        this.changeSliderPos(this.currentValue);
    }

    private void changeSliderPosFromMouse(int mouseX, int mouseY) {
        int newPos = this.scrollBar.translateValue(mouseX, mouseY) - this.scrollBar.translateValue(this.element.getX(), this.element.getY()) - this.startMouse;
        if (newPos < 0) {
            newPos = 0;
        }
        if (newPos > this.scrollBar.translateValue(this.element.getWidth(), this.element.getHeight()) - this.scrollBar.translateValue(this.scrollPos.getWidth(), this.scrollPos.getHeight())) {
            newPos = this.scrollBar.translateValue(this.element.getWidth(), this.element.getHeight()) - this.scrollBar.translateValue(this.scrollPos.getWidth(), this.scrollPos.getHeight());
        }
        this.scrollBar.setPosition(this.scrollPos, newPos);
        this.currentValue = this.viewToWorld(newPos);
        if (this.listener != null) {
            this.listener.onChangeNotify();
        }
        this.element.layoutElements();
    }

    private float viewToWorld(float viewValue) {
        return (viewValue - 0.0f) / (float)(this.scrollBar.translateValue(this.element.getWidth(), this.element.getHeight()) - 0) * (this.worldMaxValue - this.worldMinValue) + this.worldMinValue;
    }

    private float worldToView(float worldValue) {
        return (worldValue - this.worldMinValue) / (this.worldMaxValue - this.worldMinValue) * (float)(this.scrollBar.translateValue(this.element.getWidth(), this.element.getHeight()) - 0) + 0.0f;
    }

    public void changeSliderPos(float worldValue) {
        int s;
        float a;
        if (this.scrollPos == null) {
            return;
        }
        this.currentValue = worldValue;
        if (this.currentValue < 0.0f) {
            this.currentValue = 0.0f;
        }
        if (this.currentValue > (a = this.viewToWorld(s = this.scrollBar.translateValue(this.element.getWidth(), this.element.getHeight()) - this.scrollBar.translateValue(this.scrollPos.getWidth(), this.scrollPos.getHeight())))) {
            this.currentValue = a;
        }
        float newPos = this.worldToView(this.currentValue);
        this.scrollBar.setPosition(this.scrollPos, (int)newPos);
        if (this.listener != null) {
            this.listener.onChangeNotify();
        }
        this.screen.layoutLayers();
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (this.nextPrevHelper.handleNextPrev(inputEvent)) {
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorUp || inputEvent == NiftyInputEvent.MoveCursorLeft) {
            this.changeSliderPos(this.currentValue - this.pageSize);
            return true;
        }
        if (inputEvent == NiftyInputEvent.MoveCursorDown || inputEvent == NiftyInputEvent.MoveCursorRight) {
            this.changeSliderPos(this.currentValue + this.pageSize);
            return true;
        }
        return false;
    }

    public void setWorldMaxValue(float worldMaxValue) {
        this.worldMaxValue = worldMaxValue;
        this.calcPageSize();
    }

    public void setViewMaxValue(float viewMaxValue) {
        this.viewMaxValue = viewMaxValue;
        this.calcPageSize();
    }

    public float getWorldMinValue() {
        return this.worldMinValue;
    }

    public float getWorldMaxValue() {
        return this.worldMaxValue;
    }

    public float getViewMinValue() {
        return this.viewMinValue;
    }

    public float getViewMaxValue() {
        return this.viewMaxValue;
    }

    public void setPerClickChange(float perClickChange) {
        this.perClickChange = perClickChange;
    }
}

