/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.scrollbar.controller;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.elements.ControllerEventListener;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Properties;

public class SimpleSlider
implements Controller {
    private Screen screen;
    private Element element;
    private ControllerEventListener listener;
    private Element scrollPos;
    private float minValue;
    private float maxValue;
    private float currentValue;
    private boolean snap;
    private boolean fill;
    private boolean flip;

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, ControllerEventListener newListener, Attributes controlDefinitionAttributes) {
        this.element = newElement;
        this.screen = screenParam;
        this.listener = newListener;
        this.minValue = Float.parseFloat(properties.getProperty("minValue", "0.0"));
        this.maxValue = Float.parseFloat(properties.getProperty("maxValue", "1.0"));
        this.currentValue = Float.parseFloat(properties.getProperty("currentValue", "0.0"));
        this.snap = Boolean.parseBoolean(properties.getProperty("snap", "false"));
        this.fill = Boolean.parseBoolean(properties.getProperty("fill", "false"));
        this.flip = Boolean.parseBoolean(properties.getProperty("flip", "false"));
    }

    public void onStartScreen() {
        this.scrollPos = this.element.findElementByName("scrollposition");
        this.changeSliderPos(this.currentValue);
    }

    public void click(int mouseX, int mouseY) {
        this.changeSliderPosFromMouse(mouseY);
    }

    public void mouseMove(int mouseX, int mouseY) {
        this.changeSliderPosFromMouse(mouseY);
    }

    private void changeSliderPosFromMouse(int y) {
        int mousePosY = y - this.element.getY();
        if (mousePosY < 0) {
            mousePosY = 1;
        }
        if (mousePosY >= this.element.getHeight()) {
            mousePosY = this.element.getHeight() - 1;
        }
        float newValue = (float)mousePosY / (float)this.element.getHeight() * (this.maxValue - this.minValue);
        this.changeSliderPos(newValue);
    }

    private void changeSliderPos(float newValue) {
        if (this.scrollPos == null) {
            return;
        }
        if (this.flip) {
            newValue = this.maxValue - this.minValue - newValue;
        }
        this.currentValue = newValue;
        if (this.snap) {
            this.currentValue = (int)newValue;
        }
        float t = this.currentValue / (this.maxValue - this.minValue);
        float newPos = (float)this.element.getHeight() * t;
        if (!this.fill && !this.snap) {
            newPos -= (float)(this.scrollPos.getHeight() / 2);
        }
        if (newPos < 0.0f) {
            newPos = 0.0f;
        }
        if (!this.fill && newPos + (float)this.scrollPos.getHeight() > (float)this.element.getHeight()) {
            newPos = this.element.getHeight() - this.scrollPos.getHeight();
        }
        if (!this.fill) {
            this.scrollPos.setConstraintX(new SizeValue("0px"));
            this.scrollPos.setConstraintY(new SizeValue((int)newPos + "px"));
        } else {
            this.scrollPos.setConstraintX(new SizeValue("0px"));
            if (this.snap) {
                t = (this.currentValue + 1.0f) / (this.maxValue - this.minValue);
                if (t > 1.0f) {
                    t = 1.0f;
                }
                newPos = (float)this.element.getHeight() * t;
            }
            int y = (int)((float)this.element.getHeight() - newPos);
            this.scrollPos.setConstraintY(new SizeValue(y + "px"));
            int height = (int)newPos;
            this.scrollPos.setConstraintHeight(new SizeValue(height + "px"));
        }
        this.listener.onChangeNotify();
        this.screen.layoutLayers();
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }
}

