/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.loaderv2.types;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.dynamic.attributes.ControlEffectAttributes;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.loaderv2.types.EffectValueType;
import de.lessvoid.nifty.loaderv2.types.RegisterEffectType;
import de.lessvoid.nifty.loaderv2.types.XmlBaseType;
import de.lessvoid.nifty.tools.LinearInterpolator;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;

public class EffectType
extends XmlBaseType {
    private static Logger logger = Logger.getLogger(EffectType.class.getName());
    private static final boolean DEFAULT_INHERIT = false;
    private static final boolean DEFAULT_POST = false;
    private static final boolean DEFAULT_OVERLAY = false;
    protected ArrayList<EffectValueType> effectValues = new ArrayList();
    private String styleId;

    public EffectType() {
    }

    public EffectType(EffectType e) {
        super(e);
        this.effectValues = new ArrayList<EffectValueType>(e.effectValues);
    }

    public EffectType clone() {
        return new EffectType(this);
    }

    public ControlEffectAttributes convert() {
        return new ControlEffectAttributes(this.getAttributes(), this.effectValues);
    }

    public void materialize(Nifty nifty, Element element, EffectEventId effectEventId, Attributes effectsTypeAttibutes, LinkedList<Object> controllers) {
        Attributes effectAttributes = new Attributes(this.getAttributes());
        effectAttributes.merge(effectsTypeAttibutes);
        Attributes attributes = effectAttributes;
        RegisterEffectType registerEffectType = this.getRegisteredEffectType(nifty, attributes);
        if (registerEffectType == null) {
            return;
        }
        Class<?> effectClass = registerEffectType.getEffectClass();
        if (effectClass == null) {
            return;
        }
        EffectProperties effectProperties = new EffectProperties(attributes.createProperties());
        this.applyEffectValues(effectProperties);
        Effect effect = this.createEffect(nifty, effectEventId, attributes);
        effect.init(element, this.createEffectImpl(effectClass), effectProperties, nifty.getTimeProvider(), controllers);
        element.registerEffect(effectEventId, effect);
    }

    private RegisterEffectType getRegisteredEffectType(Nifty nifty, Attributes attributes) {
        String name = this.getEffectName(attributes);
        RegisterEffectType registerEffectType = nifty.resolveRegisteredEffect(name);
        if (registerEffectType == null) {
            logger.warning("unable to convert effect [" + name + "] because no effect with this name has been registered.");
            return null;
        }
        return registerEffectType;
    }

    private Effect createEffect(Nifty nifty, EffectEventId effectEventId, Attributes attributes) {
        Effect effect = new Effect(nifty, this.getInherit(attributes), this.getPost(attributes), this.getOverlay(attributes), this.getAlternateEnable(attributes), this.getAlternateDisable(attributes), this.getCustomKey(attributes), this.getNeverStopRendering(attributes), effectEventId);
        this.initializeEffect(effect, effectEventId);
        return effect;
    }

    private boolean getInherit(Attributes attributes) {
        return attributes.getAsBoolean("inherit", false);
    }

    private boolean getPost(Attributes attributes) {
        return attributes.getAsBoolean("post", false);
    }

    private boolean getOverlay(Attributes attributes) {
        return attributes.getAsBoolean("overlay", false);
    }

    private String getAlternateEnable(Attributes attributes) {
        return attributes.get("alternateEnable");
    }

    private String getAlternateDisable(Attributes attributes) {
        return attributes.get("alternateDisable");
    }

    private String getCustomKey(Attributes attributes) {
        return attributes.get("customKey");
    }

    private boolean getNeverStopRendering(Attributes attributes) {
        return attributes.getAsBoolean("neverStopRendering", false);
    }

    protected void initializeEffect(Effect effect, EffectEventId effectEventId) {
        if (EffectEventId.onFocus.equals((Object)effectEventId) || EffectEventId.onActive.equals((Object)effectEventId) || EffectEventId.onEnabled.equals((Object)effectEventId) || EffectEventId.onDisabled.equals((Object)effectEventId)) {
            effect.enableInfinite();
        }
    }

    private EffectImpl createEffectImpl(Class<?> effectClass) {
        try {
            if (EffectImpl.class.isAssignableFrom(effectClass)) {
                return (EffectImpl)effectClass.newInstance();
            }
            logger.warning("given effect class [" + effectClass.getName() + "] does not implement [" + EffectImpl.class.getName() + "]");
        }
        catch (Exception e) {
            logger.warning("class [" + effectClass.getName() + "] could not be instanziated");
        }
        return null;
    }

    private String getEffectName(Attributes attributes) {
        return attributes.get("name");
    }

    public void resolveParameters(Attributes src) {
        this.getAttributes().resolveParameters(src);
    }

    public void addValue(EffectValueType elmentValueType) {
        this.effectValues.add(elmentValueType);
    }

    void applyEffectValues(EffectProperties effectProperties) {
        if (!this.effectValues.isEmpty()) {
            for (EffectValueType effectValueType : this.effectValues) {
                effectProperties.addEffectValue(effectValueType.getAttributes());
            }
            if (effectProperties.isTimeInterpolator()) {
                LinearInterpolator interpolator = effectProperties.getInterpolator();
                effectProperties.setProperty("length", String.valueOf((long)interpolator.getMaxX()));
            }
        }
    }

    public void setStyleId(String styleId) {
        this.styleId = styleId;
    }

    public String getStyleId() {
        return this.styleId;
    }
}

