/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.listbox;

import de.lessvoid.nifty.controls.listbox.ListBoxSelectionMode;
import java.util.ArrayList;
import java.util.List;

public class ListBoxSelectionModeSingle<T>
implements ListBoxSelectionMode<T> {
    private List<T> selection = new ArrayList<T>();
    private boolean requiresSelection = false;

    @Override
    public void clear() {
        this.selection.clear();
    }

    @Override
    public List<T> getSelection() {
        return new ArrayList<T>(this.selection);
    }

    @Override
    public void remove(T item) {
        if (this.requiresSelection) {
            return;
        }
        if (this.isPartOfSelection(item)) {
            this.removeFromSelection(item);
        }
    }

    @Override
    public void removeForced(T item) {
        if (this.isPartOfSelection(item)) {
            this.removeFromSelection(item);
        }
    }

    @Override
    public void add(T item) {
        this.selection.clear();
        this.selection.add(item);
    }

    @Override
    public void enableRequiresSelection(boolean enable) {
        this.requiresSelection = enable;
    }

    @Override
    public boolean requiresAutoSelection() {
        return this.requiresSelection && this.selection.isEmpty();
    }

    private boolean isPartOfSelection(T item) {
        return this.selection.contains(item);
    }

    private void removeFromSelection(T item) {
        this.selection.remove(item);
    }
}

