/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.tabs;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.builder.ElementBuilder;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.TabSelectedEvent;
import de.lessvoid.nifty.controls.Tabs;
import de.lessvoid.nifty.controls.button.builder.ButtonBuilder;
import de.lessvoid.nifty.controls.tabs.TabControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.ElementShowEvent;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.bushe.swing.event.EventTopicSubscriber;

public class TabsControl
extends AbstractController
implements Tabs,
EventTopicSubscriber<ElementShowEvent> {
    private Nifty nifty;
    private static String activeTab;
    private Element elmnt;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(element);
        this.nifty = nifty;
        this.elmnt = element;
        nifty.subscribe(screen, this.getId(), ElementShowEvent.class, (EventTopicSubscriber)this);
    }

    public void init(Properties prprts, Attributes atrbts) {
        System.out.println("init");
        Element tabContentPanel = this.elmnt.findElementByName("#tab-content-panel");
        List elements = tabContentPanel.getElements();
        for (Element e : elements) {
            if (activeTab == null || activeTab.length() == 0) {
                activeTab = e.getId();
                this.createTabButton(e.getId(), ((TabControl)e.getControl(TabControl.class)).getCaption());
                continue;
            }
            e.hideWithoutEffect();
            this.createTabButton(e.getId(), ((TabControl)e.getControl(TabControl.class)).getCaption());
        }
    }

    private void createTabButton(final String tabId, final String buttonCaption) {
        Element tabButtonPanel = this.elmnt.findElementByName("#tab-button-panel");
        System.out.println("looking for button " + tabId + "-button");
        if (tabButtonPanel.findElementByName(tabId + "-button") == null) {
            System.out.println("adding button " + tabId + "-button");
            new ButtonBuilder(tabId + "-button"){
                {
                    super(x0);
                    this.style("nifty-button");
                    this.childLayout(ElementBuilder.ChildLayoutType.Horizontal);
                    this.interactOnClick("switchTab(" + tabId + ")");
                    this.width(this.percentage(25));
                    this.height(this.percentage(100));
                    this.label(buttonCaption);
                }
            }.build(this.nifty, this.nifty.getCurrentScreen(), tabButtonPanel);
        }
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return true;
    }

    @Override
    public void addTab(Element tab) {
        if (tab.getControl(TabControl.class) == null) {
            throw new IllegalArgumentException("Expected an Element with a TabControl.");
        }
        System.out.println("adding tab " + tab.getId());
        this.elmnt.findElementByName("#tab-content-panel").add(tab);
        this.createTabButton(tab.getId(), ((TabControl)tab.getControl(TabControl.class)).getCaption());
        this.setSelectedTab(tab.getId());
        this.elmnt.layoutElements();
    }

    @Override
    public void removeTab(int index) {
        this.removeTab(((Element)this.elmnt.findElementByName("#tab-button-panel").getElements().get(index)).getId());
    }

    public void removeTab(String tabId) {
        if (tabId.equals(activeTab) && this.elmnt.findElementByName("#tab-button-panel").getElements().size() > 1) {
            if (((Element)this.elmnt.findElementByName("#tab-button-panel").getElements().get(0)).getId().equals(tabId)) {
                this.setSelectedTab(((Element)this.elmnt.findElementByName("#tab-button-panel").getElements().get(1)).getId());
            } else {
                this.setSelectedTab(((Element)this.elmnt.findElementByName("#tab-button-panel").getElements().get(0)).getId());
            }
        }
        this.elmnt.findElementByName("#tab-button-panel").findElementByName(tabId + "-button").markForRemoval();
        this.elmnt.findElementByName("#tab-content-panel").findElementByName(tabId).markForRemoval();
        this.elmnt.layoutElements();
    }

    @Override
    public void setSelectedTab(int index) {
        this.setSelectedTab(((Element)this.elmnt.findElementByName("#tab-button-panel").getElements().get(index)).getId());
    }

    @Override
    public void setSelectedTab(String tabId) {
        this.switchTab(tabId);
    }

    @Override
    public String getSelectedTab() {
        return activeTab;
    }

    @Override
    public int getSelectedTabIndex() {
        Element e;
        int tabIndex = 0;
        if (activeTab == null || activeTab.length() == 0) {
            return -1;
        }
        Element tabContentPanel = this.elmnt.findElementByName("#tab-content-panel");
        List elements = tabContentPanel.getElements();
        Iterator i$ = elements.iterator();
        while (i$.hasNext() && !(e = (Element)i$.next()).getId().equals(activeTab)) {
            ++tabIndex;
        }
        return tabIndex;
    }

    public void switchTab(String tabId) {
        if (!tabId.equals(activeTab)) {
            if (activeTab != null) {
                this.elmnt.findElementByName("#tab-button-panel").findElementByName(activeTab + "-button").setStyle("tab-button");
            }
            this.elmnt.findElementByName("#tab-button-panel").findElementByName(tabId + "-button").setStyle("active-tab-button");
            if (activeTab != null) {
                this.elmnt.findElementByName("#tab-content-panel").findElementByName(activeTab).hideWithoutEffect();
            }
            this.elmnt.findElementByName("#tab-content-panel").findElementByName(tabId).showWithoutEffects();
            this.nifty.publishEvent(this.getId(), (NiftyEvent)new TabSelectedEvent(this, tabId));
            activeTab = tabId;
            this.elmnt.layoutElements();
        }
    }

    public void onEvent(String topic, ElementShowEvent data) {
        System.out.println("onShow: " + data.getElement());
        Element tabContentPanel = this.elmnt.findElementByName("#tab-content-panel");
        for (int i = 0; i < tabContentPanel.getElements().size(); ++i) {
            ((Element)tabContentPanel.getElements().get(i)).hideWithoutEffect();
        }
        if (activeTab != null) {
            this.elmnt.findElementByName("#tab-content-panel").findElementByName(activeTab).showWithoutEffects();
        }
    }
}

