/*
 * Decompiled with CFR 0.152.
 */
package tgaimageplugin;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import tgaimageplugin.TGAHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGAImageReader
extends ImageReader {
    public TGAImageReader(ImageReaderSpi spi) {
        super(spi);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        ImageInputStream in = (ImageInputStream)this.getInput();
        in.seek(12L);
        in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        return in.readUnsignedShort();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        ImageInputStream in = (ImageInputStream)this.getInput();
        in.seek(14L);
        in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        return in.readUnsignedShort();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        LinkedList<ImageTypeSpecifier> list = new LinkedList<ImageTypeSpecifier>();
        list.add(ImageTypeSpecifier.createFromBufferedImageType(2));
        return list.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        ImageInputStream in = (ImageInputStream)this.getInput();
        TGAHeader header = TGAHeader.create(in);
        System.out.println(header);
        int pixCount = header.getImageWidth() * header.getImageHeight();
        int bytePerPixel = header.getPixelDepth() / 8;
        byte[] buffer = new byte[bytePerPixel];
        BufferedImage image = new BufferedImage(header.getImageWidth(), header.getImageHeight(), 2);
        for (int i = 0; i < pixCount; ++i) {
            in.readFully(buffer);
            int argb = this.decodeTrueColor(buffer, bytePerPixel);
            int r = i / header.getImageWidth();
            int c = i % header.getImageWidth();
            switch (header.getFirstPixelDestination()) {
                case BOTTOM_LEFT: {
                    r = header.getImageHeight() - r - 1;
                    break;
                }
                case BOTTOM_RIGHT: {
                    r = header.getImageHeight() - r - 1;
                    c = header.getImageWidth() - c - 1;
                    break;
                }
                case TOP_LEFT: {
                    break;
                }
                case TOP_RIGHT: {
                    c = header.getImageWidth() - c - 1;
                }
            }
            image.setRGB(c, r, argb);
        }
        return image;
    }

    private int decodeTrueColor(byte[] buffer, int bytePerPixel) {
        if (bytePerPixel == 3) {
            return -16777216 + (buffer[2] << 16) + (buffer[1] << 8) + buffer[0];
        }
        if (bytePerPixel == 4) {
            return (buffer[3] << 24) + (buffer[2] << 16) + (buffer[1] << 8) + buffer[0];
        }
        throw new UnsupportedOperationException(bytePerPixel + " unsupported.");
    }
}

