/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class DirectoryExplorer {
    private Collection<File> files = new LinkedList<File>();

    public DirectoryExplorer(String[] filenames) throws IOException {
        for (String filename : filenames) {
            this.explore(new File(filename));
        }
    }

    public DirectoryExplorer(Collection<String> filenames) throws IOException {
        for (String filename : filenames) {
            this.explore(new File(filename));
        }
    }

    public DirectoryExplorer(String filename) throws IOException {
        this(new File(filename));
    }

    public DirectoryExplorer(File file) throws IOException {
        this.explore(file);
    }

    private void explore(File file) throws IOException {
        if (file.exists()) {
            this.files.add(file);
            if (file.isDirectory()) {
                this.exploreDirectory(file);
            }
        }
    }

    private void exploreDirectory(File dir) throws IOException {
        String[] entries = dir.list();
        for (int i = 0; i < entries.length; ++i) {
            this.explore(new File(dir, entries[i]));
        }
    }

    public Collection<File> getFiles() {
        return this.files;
    }
}

