/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.LoadListener;
import com.jeantessier.classreader.LoadListenerDecorator;
import com.jeantessier.text.MaximumCapacityPatternCache;
import java.util.Iterator;
import java.util.List;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.perl.Perl5Util;

public class FilteringLoadListener
extends LoadListenerDecorator {
    private Perl5Util perl = new Perl5Util((PatternCache)new MaximumCapacityPatternCache());
    protected List<String> includes;
    protected List<String> excludes;

    public FilteringLoadListener(LoadListener delegate, List<String> includes, List<String> excludes) {
        super(delegate);
        this.includes = includes;
        this.excludes = excludes;
    }

    protected boolean matches(String name) {
        return this.matches(this.includes, name) && !this.matches(this.excludes, name);
    }

    private boolean matches(List<String> regularExpressions, String name) {
        boolean found = false;
        Iterator<String> i = regularExpressions.iterator();
        while (!found && i.hasNext()) {
            String condition = i.next();
            found = this.perl.match(condition, name);
        }
        return found;
    }
}

