/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ClassNameHelper;
import com.jeantessier.classreader.SignatureIterator;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class SignatureHelper {
    private static Map<String, String> conversion = new HashMap<String, String>();

    private SignatureHelper() {
    }

    public static String convert(String type) {
        String result = null;
        Logger.getLogger(SignatureHelper.class).debug((Object)("Begin Convert(\"" + type + "\")"));
        if (type.length() == 1) {
            result = conversion.get(type);
        } else if (type.charAt(0) == 'L') {
            result = ClassNameHelper.path2ClassName(type.substring(1, type.indexOf(59)));
        } else if (type.charAt(0) == 'T') {
            result = ClassNameHelper.path2ClassName(type.substring(1, type.indexOf(59)));
        } else if (type.charAt(0) == '[') {
            result = SignatureHelper.convert(type.substring(1)) + "[]";
        }
        Logger.getLogger(SignatureHelper.class).debug((Object)("End   Convert(\"" + type + "\"): \"" + result + "\""));
        return result;
    }

    public static String getSignature(String descriptor) {
        StringBuffer result = new StringBuffer();
        Logger.getLogger(SignatureHelper.class).debug((Object)("Begin Signature(\"" + descriptor + "\")"));
        result.append("(");
        int start = descriptor.indexOf("(") + 1;
        int end = descriptor.indexOf(")");
        SignatureIterator i = new SignatureIterator(descriptor.substring(start, end));
        while (i.hasNext()) {
            result.append(i.next());
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        result.append(")");
        Logger.getLogger(SignatureHelper.class).debug((Object)("End   Signature(\"" + descriptor + "\"): \"" + result + "\""));
        return result.toString();
    }

    public static int getParameterCount(String descriptor) {
        int result = 0;
        Logger.getLogger(SignatureHelper.class).debug((Object)("Begin ParameterCount(\"" + descriptor + "\")"));
        int start = descriptor.indexOf("(") + 1;
        int end = descriptor.indexOf(")");
        SignatureIterator i = new SignatureIterator(descriptor.substring(start, end));
        while (i.hasNext()) {
            i.next();
            ++result;
        }
        Logger.getLogger(SignatureHelper.class).debug((Object)("End   ParameterCount(\"" + descriptor + "\"): \"" + result + "\""));
        return result;
    }

    public static String getReturnType(String descriptor) {
        return SignatureHelper.convert(descriptor.substring(descriptor.lastIndexOf(")") + 1));
    }

    public static String getType(String descriptor) {
        return SignatureHelper.convert(descriptor);
    }

    static {
        conversion.put("B", "byte");
        conversion.put("C", "char");
        conversion.put("D", "double");
        conversion.put("F", "float");
        conversion.put("I", "int");
        conversion.put("J", "long");
        conversion.put("S", "short");
        conversion.put("V", "void");
        conversion.put("Z", "boolean");
    }
}

