/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ClassfileLoaderAction;
import com.jeantessier.classreader.ClassfileLoaderDispatcher;
import java.io.File;
import org.apache.log4j.Logger;

public class StrictDispatcher
implements ClassfileLoaderDispatcher {
    @Override
    public ClassfileLoaderAction dispatch(String filename) {
        ClassfileLoaderAction result;
        if (filename.endsWith(".jar")) {
            result = ClassfileLoaderAction.JAR;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_JAR"));
        } else if (filename.endsWith(".zip")) {
            result = ClassfileLoaderAction.ZIP;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_ZIP"));
        } else if (filename.endsWith(".class")) {
            result = ClassfileLoaderAction.CLASS;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_CLASS"));
        } else if (new File(filename).exists()) {
            result = ClassfileLoaderAction.DIRECTORY;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_DIRECTORY"));
        } else {
            result = ClassfileLoaderAction.IGNORE;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_IGNORE"));
        }
        return result;
    }
}

