/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.ClassNameHelper;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.ElementValueFactory;
import com.jeantessier.classreader.impl.ElementValuePair;
import com.jeantessier.classreader.impl.UTF8_info;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class Annotation
implements com.jeantessier.classreader.Annotation {
    private ConstantPool constantPool;
    private Collection<ElementValuePair> elementValuePairs = new LinkedList<ElementValuePair>();
    private int typeIndex;

    public Annotation(ConstantPool constantPool, DataInput in) throws IOException {
        this(constantPool, in, new ElementValueFactory());
    }

    public Annotation(ConstantPool constantPool, DataInput in, ElementValueFactory elementValueFactory) throws IOException {
        this.constantPool = constantPool;
        this.typeIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Type index: " + this.typeIndex + " (" + this.getType() + ")"));
        int numElementValuePairs = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + numElementValuePairs + " element value pair(s) ..."));
        for (int i = 0; i < numElementValuePairs; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Element value pair " + i + ":"));
            this.elementValuePairs.add(new ElementValuePair(constantPool, in, elementValueFactory));
        }
    }

    @Override
    public int getTypeIndex() {
        return this.typeIndex;
    }

    @Override
    public UTF8_info getRawType() {
        return (UTF8_info)this.constantPool.get(this.getTypeIndex());
    }

    @Override
    public String getType() {
        String result = "";
        if (this.getTypeIndex() != 0) {
            result = ClassNameHelper.convertClassName(this.getRawType().getValue());
        }
        return result;
    }

    public Collection<? extends ElementValuePair> getElementValuePairs() {
        return this.elementValuePairs;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitAnnotation(this);
    }
}

