/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.ConstantPoolEntry;
import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.AttributeType;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.ConstantPool;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ConstantValue_attribute
extends Attribute_info
implements com.jeantessier.classreader.ConstantValue_attribute {
    private int valueIndex;

    public ConstantValue_attribute(ConstantPool constantPool, Visitable owner, DataInput in) throws IOException {
        super(constantPool, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        this.valueIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Constant value: " + this.getValueIndex() + " (" + this.getRawValue() + ")"));
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public ConstantPoolEntry getRawValue() {
        return (ConstantPoolEntry)this.getConstantPool().get(this.getValueIndex());
    }

    public String toString() {
        return "ConstantValue " + this.getRawValue();
    }

    public int hashCode() {
        return this.getRawValue().hashCode();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (this == object) {
            result = true;
        } else if (object != null && this.getClass().equals(object.getClass())) {
            ConstantValue_attribute other = (ConstantValue_attribute)object;
            result = this.getRawValue().equals(other.getRawValue());
        }
        return result;
    }

    @Override
    public String getAttributeName() {
        return AttributeType.CONSTANT_VALUE.getAttributeName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitConstantValue_attribute(this);
    }
}

