/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.DescriptorHelper;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.ElementValue;
import com.jeantessier.classreader.impl.ElementValueType;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class EnumElementValue
extends ElementValue
implements com.jeantessier.classreader.EnumElementValue {
    private int typeNameIndex;
    private int constNameIndex;

    public EnumElementValue(ConstantPool constantPool, DataInput in) throws IOException {
        super(constantPool);
        this.typeNameIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Type name index: " + this.typeNameIndex));
        this.constNameIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Const name index: " + this.constNameIndex));
    }

    @Override
    public int getTypeNameIndex() {
        return this.typeNameIndex;
    }

    @Override
    public UTF8_info getRawTypeName() {
        return (UTF8_info)this.getConstantPool().get(this.getTypeNameIndex());
    }

    @Override
    public String getTypeName() {
        String result = "";
        if (this.getTypeNameIndex() != 0) {
            result = DescriptorHelper.getType(this.getRawTypeName().getValue());
        }
        return result;
    }

    @Override
    public int getConstNameIndex() {
        return this.constNameIndex;
    }

    @Override
    public UTF8_info getRawConstName() {
        return (UTF8_info)this.getConstantPool().get(this.getConstNameIndex());
    }

    @Override
    public String getConstName() {
        return this.getRawConstName().getValue();
    }

    @Override
    public char getTag() {
        return ElementValueType.ENUM.getTag();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitEnumElementValue(this);
    }
}

