/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.Class_info;
import com.jeantessier.classreader.impl.InnerClasses_attribute;
import com.jeantessier.classreader.impl.UTF8_info;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class InnerClass
implements com.jeantessier.classreader.InnerClass {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_SYNTHETIC = 4096;
    private static final int ACC_ANNOTATION = 8192;
    private static final int ACC_ENUM = 16384;
    private InnerClasses_attribute innerClasses;
    private int innerClassInfoIndex;
    private int outerClassInfoIndex;
    private int innerNameIndex;
    private int accessFlag;

    public InnerClass(InnerClasses_attribute innerClasses, DataInput in) throws IOException {
        this.innerClasses = innerClasses;
        this.innerClassInfoIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Inner class info index: " + this.innerClassInfoIndex + " (" + this.getInnerClassInfo() + ")"));
        this.outerClassInfoIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Outer class info index: " + this.outerClassInfoIndex + " (" + this.getOuterClassInfo() + ")"));
        this.innerNameIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Inner name index: " + this.innerNameIndex + " (" + this.getInnerName() + ")"));
        this.accessFlag = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Inner class access flag: " + this.accessFlag));
    }

    @Override
    public InnerClasses_attribute getInnerClasses() {
        return this.innerClasses;
    }

    @Override
    public int getInnerClassInfoIndex() {
        return this.innerClassInfoIndex;
    }

    @Override
    public Class_info getRawInnerClassInfo() {
        return (Class_info)this.innerClasses.getConstantPool().get(this.getInnerClassInfoIndex());
    }

    @Override
    public String getInnerClassInfo() {
        String result = "";
        if (this.getInnerClassInfoIndex() != 0) {
            result = this.getRawInnerClassInfo().getName();
        }
        return result;
    }

    @Override
    public int getOuterClassInfoIndex() {
        return this.outerClassInfoIndex;
    }

    @Override
    public Class_info getRawOuterClassInfo() {
        return (Class_info)this.innerClasses.getConstantPool().get(this.getOuterClassInfoIndex());
    }

    @Override
    public String getOuterClassInfo() {
        String result = "";
        if (this.getOuterClassInfoIndex() != 0) {
            result = this.getRawOuterClassInfo().getName();
        }
        return result;
    }

    @Override
    public int getInnerNameIndex() {
        return this.innerNameIndex;
    }

    @Override
    public UTF8_info getRawInnerName() {
        return (UTF8_info)this.innerClasses.getConstantPool().get(this.getInnerNameIndex());
    }

    @Override
    public String getInnerName() {
        String result = "";
        if (this.getInnerNameIndex() != 0) {
            result = this.getRawInnerName().getValue();
        }
        return result;
    }

    @Override
    public int getAccessFlag() {
        return this.accessFlag;
    }

    @Override
    public boolean isPublic() {
        return (this.getAccessFlag() & 1) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.getAccessFlag() & 4) != 0;
    }

    @Override
    public boolean isPrivate() {
        return (this.getAccessFlag() & 2) != 0;
    }

    @Override
    public boolean isPackage() {
        return (this.getAccessFlag() & 7) == 0;
    }

    @Override
    public boolean isStatic() {
        return (this.getAccessFlag() & 8) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.getAccessFlag() & 0x10) != 0;
    }

    @Override
    public boolean isInterface() {
        return (this.getAccessFlag() & 0x200) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.getAccessFlag() & 0x400) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getAccessFlag() & 0x1000) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.getAccessFlag() & 0x2000) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.getAccessFlag() & 0x4000) != 0;
    }

    @Override
    public boolean isMemberClass() {
        return this.getOuterClassInfoIndex() != 0;
    }

    @Override
    public boolean isAnonymousClass() {
        return this.getInnerNameIndex() == 0;
    }

    public String toString() {
        return this.getInnerClassInfo();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInnerClass(this);
    }
}

