/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.commandline;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.commandline.CommandLineSwitch;
import com.jeantessier.commandline.Visitor;
import java.util.Collection;
import java.util.LinkedList;

public class AliasSwitch
implements CommandLineSwitch {
    private Collection<CommandLineSwitch> switches = new LinkedList<CommandLineSwitch>();
    private String name;

    public AliasSwitch(String name, CommandLineSwitch ... switches) {
        this.name = name;
        for (CommandLineSwitch commandLineSwitch : switches) {
            this.switches.add(commandLineSwitch);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Collection<CommandLineSwitch> getSwitches() {
        return this.switches;
    }

    @Override
    public Object getDefaultValue() {
        return "";
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object value) {
        for (CommandLineSwitch commandLineSwitch : this.getSwitches()) {
            commandLineSwitch.setValue(value);
        }
    }

    @Override
    public boolean isPresent() {
        boolean result = !this.getSwitches().isEmpty();
        for (CommandLineSwitch commandLineSwitch : this.getSwitches()) {
            result = result && commandLineSwitch.isPresent();
        }
        return result;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void validate() throws CommandLineException {
    }

    @Override
    public int parse(String value) throws CommandLineException {
        int result = 1;
        for (CommandLineSwitch commandLineSwitch : this.getSwitches()) {
            result = Math.max(result, commandLineSwitch.parse(value));
        }
        return result;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitAliasSwitch(this);
    }
}

