/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.VisitorDecorator;
import java.util.Collection;

public class BasicTraversal
extends VisitorDecorator {
    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.accept(this.getDelegate());
        }
    }

    @Override
    public void traverseInbound(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.acceptInbound(this.getDelegate());
        }
    }

    @Override
    public void traverseOutbound(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.acceptOutbound(this.getDelegate());
        }
    }

    @Override
    public void visitPackageNode(PackageNode node) {
        this.traverseNodeDependencies(node);
        this.getDelegate().traverseNodes(node.getClasses());
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitClassNode(ClassNode node) {
        this.traverseNodeDependencies(node);
        this.getDelegate().traverseNodes(node.getFeatures());
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
    }

    @Override
    public void visitFeatureNode(FeatureNode node) {
        this.traverseNodeDependencies(node);
    }

    private void traverseNodeDependencies(Node node) {
        this.getDelegate().traverseInbound(node.getInboundDependencies());
        this.getDelegate().traverseOutbound(node.getOutboundDependencies());
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
    }
}

