/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.SelectionCriteria;
import java.util.Collection;

public class CollectionSelectionCriteria
implements SelectionCriteria {
    private boolean matchingPackages = true;
    private boolean matchingClasses = true;
    private boolean matchingFeatures = true;
    private Collection<String> include;
    private Collection<String> exclude;

    public CollectionSelectionCriteria(Collection<String> include, Collection<String> exclude) {
        this.include = include;
        this.exclude = exclude;
    }

    @Override
    public boolean isMatchingPackages() {
        return this.matchingPackages;
    }

    public void setMatchingPackages(boolean matchingPackages) {
        this.matchingPackages = matchingPackages;
    }

    @Override
    public boolean isMatchingClasses() {
        return this.matchingClasses;
    }

    public void setMatchingClasses(boolean matchingClasses) {
        this.matchingClasses = matchingClasses;
    }

    @Override
    public boolean isMatchingFeatures() {
        return this.matchingFeatures;
    }

    public void setMatchingFeatures(boolean matchingFeatures) {
        this.matchingFeatures = matchingFeatures;
    }

    @Override
    public boolean matches(PackageNode node) {
        return this.matchesName(node.getName());
    }

    @Override
    public boolean matches(ClassNode node) {
        return this.matchesName(node.getName());
    }

    @Override
    public boolean matches(FeatureNode node) {
        return this.matchesName(node.getName());
    }

    @Override
    public boolean matchesPackageName(String name) {
        return this.matchesName(name);
    }

    @Override
    public boolean matchesClassName(String name) {
        return this.matchesName(name);
    }

    @Override
    public boolean matchesFeatureName(String name) {
        return this.matchesName(name);
    }

    private boolean matchesName(String name) {
        return !(this.include != null && !this.include.contains(name) || this.exclude != null && this.exclude.contains(name));
    }
}

