/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.Visitor;
import java.util.Collection;

public class FeatureResolver
implements Visitor {
    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            node.accept(this);
        }
    }

    @Override
    public void traverseInbound(Collection<? extends Node> nodes) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    @Override
    public void traverseOutbound(Collection<? extends Node> nodes) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    @Override
    public void visitPackageNode(PackageNode node) {
        this.traverseNodes(node.getClasses());
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitClassNode(ClassNode node) {
        this.traverseNodes(node.getFeatures());
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
    }

    @Override
    public void visitFeatureNode(FeatureNode node) {
        String featureName = node.getSimpleName();
        for (FeatureNode inheritedFeature : node.getClassNode().getInheritedFeatures(featureName)) {
            for (Node dependent : node.getInboundDependencies()) {
                dependent.addDependency(inheritedFeature);
            }
        }
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
    }
}

