/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.DependencyEvent;
import com.jeantessier.dependency.DependencyListener;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.NodeFactory;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class NodeHandler
extends DefaultHandler {
    private static final int PACKAGE = 1;
    private static final int CLASS = 2;
    private static final int FEATURE = 3;
    private NodeFactory factory;
    private int currentNodeType;
    private int currentDependencyType;
    private Attributes currentDependencyAttributes;
    private Node currentNode;
    private Attributes currentPackageAttributes;
    private Attributes currentClassAttributes;
    private Attributes currentFeatureAttributes;
    private StringBuffer currentName = new StringBuffer();
    private HashSet<DependencyListener> dependencyListeners = new HashSet();

    public NodeHandler() {
        this(new NodeFactory());
    }

    public NodeHandler(NodeFactory factory) {
        this.factory = factory;
    }

    public NodeFactory getFactory() {
        return this.factory;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Logger.getLogger(this.getClass()).debug((Object)("qName = " + qName));
        for (int i = 0; i < atts.getLength(); ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("    " + atts.getQName(i) + ": " + atts.getValue(i)));
        }
        this.currentName.delete(0, this.currentName.length());
        if ("dependencies".equals(qName)) {
            this.fireBeginSession();
        } else if ("package".equals(qName)) {
            this.currentNodeType = 1;
            this.currentPackageAttributes = new AttributesImpl(atts);
        } else if ("class".equals(qName)) {
            this.currentNodeType = 2;
            this.currentClassAttributes = new AttributesImpl(atts);
        } else if ("feature".equals(qName)) {
            this.currentNodeType = 3;
            this.currentFeatureAttributes = new AttributesImpl(atts);
        } else if ("inbound".equals(qName) || "outbound".equals(qName)) {
            if ("package".equals(atts.getValue("type"))) {
                this.currentDependencyType = 1;
            } else if ("class".equals(atts.getValue("type"))) {
                this.currentDependencyType = 2;
            } else if ("feature".equals(atts.getValue("type"))) {
                this.currentDependencyType = 3;
            }
            this.currentDependencyAttributes = new AttributesImpl(atts);
        }
        Logger.getLogger(this.getClass()).debug((Object)("    current node type: " + this.currentNodeType));
        Logger.getLogger(this.getClass()).debug((Object)("    current dependency type: " + this.currentDependencyType));
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        Logger.getLogger(this.getClass()).debug((Object)("qName = " + qName));
        if ("dependencies".equals(qName)) {
            this.fireEndSession();
        } else if ("name".equals(qName)) {
            Logger.getLogger(this.getClass()).debug((Object)"    Processing <name> tag:");
            Logger.getLogger(this.getClass()).debug((Object)("        current name: " + this.currentName));
            Logger.getLogger(this.getClass()).debug((Object)("        current node type: " + this.currentNodeType));
            switch (this.currentNodeType) {
                case 1: {
                    this.currentNode = this.getFactory().createPackage(this.currentName.toString(), this.isConfirmed(this.currentPackageAttributes));
                    break;
                }
                case 2: {
                    this.currentNode = this.getFactory().createClass(this.currentName.toString(), this.isConfirmed(this.currentClassAttributes));
                    this.fireBeginClass(this.currentNode.getName());
                    break;
                }
                case 3: {
                    this.currentNode = this.getFactory().createFeature(this.currentName.toString(), this.isConfirmed(this.currentFeatureAttributes));
                }
            }
        } else if ("outbound".equals(qName)) {
            Logger.getLogger(this.getClass()).debug((Object)"    Processing <outbound> tag:");
            Logger.getLogger(this.getClass()).debug((Object)("        current_name: " + this.currentName));
            Logger.getLogger(this.getClass()).debug((Object)("        current_dependency_type: " + this.currentDependencyType));
            Node other = null;
            switch (this.currentDependencyType) {
                case 1: {
                    other = this.getFactory().createPackage(this.currentName.toString(), this.isConfirmed(this.currentDependencyAttributes));
                    break;
                }
                case 2: {
                    other = this.getFactory().createClass(this.currentName.toString(), this.isConfirmed(this.currentDependencyAttributes));
                    break;
                }
                case 3: {
                    other = this.getFactory().createFeature(this.currentName.toString(), this.isConfirmed(this.currentDependencyAttributes));
                }
            }
            this.currentNode.addDependency(other);
            this.fireDependency(this.currentNode, other);
        } else if ("inbound".equals(qName)) {
            Logger.getLogger(this.getClass()).debug((Object)"    Processing <inbound> tag:");
            Logger.getLogger(this.getClass()).debug((Object)("        current_name: " + this.currentName));
            Logger.getLogger(this.getClass()).debug((Object)("        current_dependency_type: " + this.currentDependencyType));
            Node other = null;
            switch (this.currentDependencyType) {
                case 1: {
                    other = this.getFactory().createPackage(this.currentName.toString(), this.isConfirmed(this.currentDependencyAttributes));
                    break;
                }
                case 2: {
                    other = this.getFactory().createClass(this.currentName.toString(), this.isConfirmed(this.currentDependencyAttributes));
                    break;
                }
                case 3: {
                    other = this.getFactory().createFeature(this.currentName.toString(), this.isConfirmed(this.currentDependencyAttributes));
                }
            }
            other.addDependency(this.currentNode);
            this.fireDependency(other, this.currentNode);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentName.append(ch, start, length);
        Logger.getLogger(this.getClass()).debug((Object)("characters: \"" + new String(ch, start, length) + "\""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependencyListener(DependencyListener listener) {
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            this.dependencyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependencyListener(DependencyListener listener) {
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            this.dependencyListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeginSession() {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.beginSession(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeginClass(String classname) {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this, classname);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.beginClass(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDependency(Node dependent, Node dependable) {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this, dependent, dependable);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.dependency(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndClass(String classname) {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this, classname);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.endClass(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndSession() {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.endSession(event);
        }
    }

    private boolean isConfirmed(Attributes atts) {
        return atts.getValue("confirmed") == null || "yes".equalsIgnoreCase(atts.getValue("confirmed"));
    }
}

