/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.TraversalStrategy;
import com.jeantessier.dependency.VisitorDecorator;
import java.util.Collection;

public class SelectiveVisitor
extends VisitorDecorator {
    private final TraversalStrategy traversalStrategy;

    public SelectiveVisitor(TraversalStrategy traversalStrategy) {
        this.traversalStrategy = traversalStrategy;
    }

    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        super.traverseNodes(this.traversalStrategy.order(nodes));
    }

    @Override
    public void traverseInbound(Collection<? extends Node> nodes) {
        super.traverseInbound(this.traversalStrategy.order(nodes));
    }

    @Override
    public void traverseOutbound(Collection<? extends Node> nodes) {
        super.traverseOutbound(this.traversalStrategy.order(nodes));
    }

    @Override
    public void visitPackageNode(PackageNode node) {
        if (this.traversalStrategy.isInScope(node)) {
            super.visitPackageNode(node);
        }
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
        if (this.traversalStrategy.isInFilter(node)) {
            super.visitInboundPackageNode(node);
        }
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
        if (this.traversalStrategy.isInFilter(node)) {
            super.visitOutboundPackageNode(node);
        }
    }

    @Override
    public void visitClassNode(ClassNode node) {
        if (this.traversalStrategy.isInScope(node)) {
            super.visitClassNode(node);
        }
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
        if (this.traversalStrategy.isInFilter(node)) {
            super.visitInboundClassNode(node);
        }
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
        if (this.traversalStrategy.isInFilter(node)) {
            super.visitOutboundClassNode(node);
        }
    }

    @Override
    public void visitFeatureNode(FeatureNode node) {
        if (this.traversalStrategy.isInScope(node)) {
            super.visitFeatureNode(node);
        }
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
        if (this.traversalStrategy.isInFilter(node)) {
            super.visitInboundFeatureNode(node);
        }
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
        if (this.traversalStrategy.isInFilter(node)) {
            super.visitOutboundFeatureNode(node);
        }
    }
}

