/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.PackageMapper;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import com.jeantessier.diff.APIDifferenceStrategy;
import com.jeantessier.diff.CodeDifferenceStrategy;
import com.jeantessier.diff.DifferenceStrategy;
import com.jeantessier.diff.Differences;
import com.jeantessier.diff.DifferencesFactory;
import com.jeantessier.diff.IncompatibleDifferenceStrategy;
import com.jeantessier.diff.ListBasedDifferenceStrategy;
import com.jeantessier.diff.NoDifferenceStrategy;
import com.jeantessier.diff.Report;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class JarJarDiff
extends Task {
    public static final String API_STRATEGY = "api";
    public static final String INCOMPATIBLE_STRATEGY = "incompatible";
    public static final String DEFAULT_LEVEL = "api";
    private String name = "";
    private Path oldPath;
    private String oldLabel;
    private Path newPath;
    private String newLabel;
    private File filter;
    private String level = "api";
    private boolean code;
    private String encoding = "utf-8";
    private String dtdPrefix = "http://depfind.sourceforge.net/dtd";
    private String indentText;
    private File destfile;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Path createOld() {
        if (this.oldPath == null) {
            this.oldPath = new Path(this.getProject());
        }
        return this.oldPath;
    }

    public Path getOld() {
        return this.oldPath;
    }

    public String getOldlabel() {
        return this.oldLabel;
    }

    public void setOldlabel(String oldLabel) {
        this.oldLabel = oldLabel;
    }

    public Path createNew() {
        if (this.newPath == null) {
            this.newPath = new Path(this.getProject());
        }
        return this.newPath;
    }

    public Path getNew() {
        return this.newPath;
    }

    public String getNewlabel() {
        return this.newLabel;
    }

    public void setNewlabel(String newLabel) {
        this.newLabel = newLabel;
    }

    public File getFilter() {
        return this.filter;
    }

    public void setfilter(File filter) {
        this.filter = filter;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public boolean getCode() {
        return this.code;
    }

    public void setCode(boolean code) {
        this.code = code;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDtdprefix() {
        return this.dtdPrefix;
    }

    public void setDtdprefix(String dtdPrefix) {
        this.dtdPrefix = dtdPrefix;
    }

    public String getIndenttext() {
        return this.indentText;
    }

    public void setIntenttext(String indentText) {
        this.indentText = indentText;
    }

    public File getDestfile() {
        return this.destfile;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    void validateParameters() throws BuildException {
        if (this.getOld() == null) {
            throw new BuildException("old must be set!");
        }
        if (this.getOldlabel() == null) {
            this.setOldlabel(this.getOld().toString());
        }
        if (this.getNew() == null) {
            throw new BuildException("new must be set!");
        }
        if (this.getNewlabel() == null) {
            this.setNewlabel(this.getNew().toString());
        }
        if (this.getDestfile() == null) {
            throw new BuildException("destfile must be set!");
        }
    }

    public void execute() throws BuildException {
        this.validateParameters();
        VerboseListener verboseListener = new VerboseListener(this);
        try {
            this.log("Loading old classes from path " + this.getOld());
            PackageMapper oldPackages = new PackageMapper();
            AggregatingClassfileLoader oldJar = new AggregatingClassfileLoader();
            ((ClassfileLoader)oldJar).addLoadListener(oldPackages);
            ((ClassfileLoader)oldJar).addLoadListener(verboseListener);
            oldJar.load(Arrays.asList(this.getOld().list()));
            this.log("Loading new classes from path " + this.getNew());
            PackageMapper newPackages = new PackageMapper();
            AggregatingClassfileLoader newJar = new AggregatingClassfileLoader();
            ((ClassfileLoader)newJar).addLoadListener(newPackages);
            ((ClassfileLoader)newJar).addLoadListener(verboseListener);
            newJar.load(Arrays.asList(this.getNew().list()));
            this.log("Comparing old and new classes ...");
            Differences differences = this.getDifferencesFactory().createProjectDifferences(this.getName(), this.getOldlabel(), oldPackages, this.getNewlabel(), newPackages);
            this.log("Saving difference report to " + this.getDestfile().getAbsolutePath());
            Report report = new Report(this.getEncoding(), this.getDtdprefix());
            if (this.getIndenttext() != null) {
                report.setIndentText(this.getIndenttext());
            }
            differences.accept(report);
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            out.print(report.render());
            out.close();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private DifferencesFactory getDifferencesFactory() throws IOException {
        DifferenceStrategy baseStrategy = this.getBaseStrategy(this.getCode());
        DifferenceStrategy strategy = this.getStrategy(this.getLevel(), baseStrategy);
        if (this.getFilter() != null) {
            strategy = new ListBasedDifferenceStrategy(strategy, this.getFilter());
        }
        return new DifferencesFactory(strategy);
    }

    private DifferenceStrategy getBaseStrategy(boolean useCode) {
        DifferenceStrategy baseStrategy = useCode ? new CodeDifferenceStrategy() : new NoDifferenceStrategy();
        return baseStrategy;
    }

    private DifferenceStrategy getStrategy(String level, DifferenceStrategy baseStrategy) {
        DifferenceStrategy strategy;
        if ("api".equals(level)) {
            strategy = new APIDifferenceStrategy(baseStrategy);
        } else if (INCOMPATIBLE_STRATEGY.equals(level)) {
            strategy = new IncompatibleDifferenceStrategy(baseStrategy);
        } else {
            try {
                try {
                    Constructor<?> constructor = Class.forName(level).getConstructor(DifferenceStrategy.class);
                    strategy = (DifferenceStrategy)constructor.newInstance(baseStrategy);
                }
                catch (NoSuchMethodException ex) {
                    strategy = (DifferenceStrategy)Class.forName(level).newInstance();
                }
            }
            catch (InvocationTargetException ex) {
                this.log("Unknown level \"" + level + "\", using default level \"" + "api" + "\": " + ex.getMessage());
                strategy = this.getDefaultStrategy(baseStrategy);
            }
            catch (InstantiationException ex) {
                this.log("Unknown level \"" + level + "\", using default level \"" + "api" + "\": " + ex.getMessage());
                strategy = this.getDefaultStrategy(baseStrategy);
            }
            catch (IllegalAccessException ex) {
                this.log("Unknown level \"" + level + "\", using default level \"" + "api" + "\": " + ex.getMessage());
                strategy = this.getDefaultStrategy(baseStrategy);
            }
            catch (ClassNotFoundException ex) {
                this.log("Unknown level \"" + level + "\", using default level \"" + "api" + "\": " + ex.getMessage());
                strategy = this.getDefaultStrategy(baseStrategy);
            }
            catch (ClassCastException ex) {
                this.log("Unknown level \"" + level + "\", using default level \"" + "api" + "\": " + ex.getMessage());
                strategy = this.getDefaultStrategy(baseStrategy);
            }
        }
        return strategy;
    }

    private APIDifferenceStrategy getDefaultStrategy(DifferenceStrategy baseStrategy) {
        return new APIDifferenceStrategy(baseStrategy);
    }
}

