/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependencyfinder.cli.ClassMatcher;
import com.jeantessier.dependencyfinder.cli.DirectoryExplorerCommand;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassFinder
extends DirectoryExplorerCommand {
    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.getCommandLine().addMultipleValuesSwitch("includes", "//");
        this.getCommandLine().addMultipleValuesSwitch("excludes");
        this.getCommandLine().addToggleSwitch("compact");
        this.getCommandLine().addSingleValueSwitch("indent-text", "    ");
    }

    @Override
    public void doProcessing() throws Exception {
        ClassMatcher matcher = new ClassMatcher(this.getCommandLine().getMultipleSwitch("includes"), this.getCommandLine().getMultipleSwitch("excludes"));
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(matcher);
        ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
        loader.load(this.getCommandLine().getParameters());
        for (Map.Entry<String, List<String>> entry : matcher.getResults().entrySet()) {
            String className = entry.getKey();
            List<String> groups = entry.getValue();
            if (this.getCommandLine().getToggleSwitch("compact")) {
                this.printCompact(className, groups);
                continue;
            }
            this.printMultiline(className, groups);
        }
    }

    private void printCompact(String className, List<String> groups) throws IOException {
        this.getOut().print(className);
        this.getOut().print(": ");
        Iterator<String> i = groups.iterator();
        while (i.hasNext()) {
            this.getOut().print((Object)i.next());
            if (!i.hasNext()) continue;
            this.getOut().print(", ");
        }
        this.getOut().println();
    }

    private void printMultiline(String className, List<String> groups) throws IOException {
        this.getOut().println(className);
        for (String group : groups) {
            this.getOut().println(this.getCommandLine().getSingleSwitch("indent-text") + group);
        }
        this.getOut().println();
    }

    public static void main(String[] args) throws Exception {
        new ClassFinder().run(args);
    }
}

