/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.TransitiveClosure;
import com.jeantessier.dependency.XMLPrinter;
import com.jeantessier.dependencyfinder.cli.DependencyGraphCommand;

public class DependencyClosure
extends DependencyGraphCommand {
    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd", "    ");
        this.populateCommandLineSwitchesForStartCondition();
        this.populateCommandLineSwitchesForStopCondition();
        this.getCommandLine().addOptionalValueSwitch("maximum-inbound-depth");
        this.getCommandLine().addOptionalValueSwitch("maximum-outbound-depth");
        this.getCommandLine().addToggleSwitch("xml");
    }

    @Override
    protected void doProcessing() throws Exception {
        TransitiveClosure selector = new TransitiveClosure(this.getStartCriteria(), this.getStopCriteria());
        try {
            if (this.getCommandLine().isPresent("maximum-inbound-depth")) {
                selector.setMaximumInboundDepth(Long.parseLong(this.getCommandLine().getSingleSwitch("maximum-inbound-depth")));
            }
        }
        catch (NumberFormatException ex) {
            selector.setMaximumInboundDepth(Long.MAX_VALUE);
        }
        try {
            if (this.getCommandLine().isPresent("maximum-outbound-depth")) {
                selector.setMaximumOutboundDepth(Long.parseLong(this.getCommandLine().getSingleSwitch("maximum-outbound-depth")));
            }
        }
        catch (NumberFormatException ex) {
            selector.setMaximumOutboundDepth(Long.MAX_VALUE);
        }
        selector.traverseNodes(this.loadGraph().getPackages().values());
        this.getVerboseListener().print("Printing the graph ...");
        Printer printer = this.getCommandLine().isPresent("xml") ? new XMLPrinter(this.getOut(), this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix")) : new TextPrinter(this.getOut());
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        printer.traverseNodes(selector.getFactory().getPackages().values());
    }

    public static void main(String[] args) throws Exception {
        new DependencyClosure().run(args);
    }
}

