/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependencyfinder.cli.Command;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public abstract class DependencyGraphCommand
extends Command {
    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.getCommandLine().addToggleSwitch("validate");
    }

    @Override
    protected void showSpecificUsage(PrintStream out) {
        out.println();
        out.println("Default is text output to the console.");
        out.println();
    }

    protected NodeFactory loadGraph() throws IOException, SAXException, ParserConfigurationException {
        NodeFactory result = new NodeFactory();
        if (this.getCommandLine().getParameters().isEmpty()) {
            this.loadGraphFromSystemIn(result);
        } else {
            this.loadGraphFromFiles(result);
        }
        return result;
    }

    private void loadGraphFromSystemIn(NodeFactory factory) throws IOException, SAXException, ParserConfigurationException {
        this.getVerboseListener().print("Reading from standard input");
        NodeLoader loader = new NodeLoader(factory, this.getCommandLine().getToggleSwitch("validate"));
        loader.addDependencyListener(this.getVerboseListener());
        loader.load(System.in);
        this.getVerboseListener().print("Read from standard input.");
    }

    private void loadGraphFromFiles(NodeFactory factory) throws IOException, SAXException, ParserConfigurationException {
        for (String filename : this.getCommandLine().getParameters()) {
            if (filename.endsWith(".xml")) {
                this.loadGraphFromFile(factory, filename);
                continue;
            }
            this.getVerboseListener().print("Skipping \"" + filename + "\".");
        }
    }

    private void loadGraphFromFile(NodeFactory factory, String filename) throws IOException, SAXException, ParserConfigurationException {
        this.getVerboseListener().print("Reading " + filename);
        NodeLoader loader = new NodeLoader(factory, this.getCommandLine().getToggleSwitch("validate"));
        loader.addDependencyListener(this.getVerboseListener());
        loader.load(filename);
        this.getVerboseListener().print("Read \"" + filename + "\".");
    }
}

