/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependency.GraphCopier;
import com.jeantessier.dependency.GraphSummarizer;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependency.NodeLoader;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.SelectiveTraversalStrategy;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.Visitor;
import com.jeantessier.dependency.XMLPrinter;
import com.jeantessier.dependencyfinder.cli.DependencyGraphCommand;
import java.io.IOException;
import java.util.Collection;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class DependencyReporter
extends DependencyGraphCommand {
    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd", "    ");
        this.populateCommandLineSwitchesForScoping();
        this.populateCommandLineSwitchesForFiltering();
        this.getCommandLine().addAliasSwitch("p2p", "package-scope", "package-filter");
        this.getCommandLine().addAliasSwitch("c2p", "class-scope", "package-filter");
        this.getCommandLine().addAliasSwitch("c2c", "class-scope", "class-filter");
        this.getCommandLine().addAliasSwitch("f2f", "feature-scope", "feature-filter");
        this.getCommandLine().addAliasSwitch("includes", "scope-includes", "filter-includes");
        this.getCommandLine().addAliasSwitch("excludes", "scope-excludes", "filter-excludes");
        this.getCommandLine().addToggleSwitch("show-inbounds");
        this.getCommandLine().addToggleSwitch("show-outbounds");
        this.getCommandLine().addToggleSwitch("show-empty-nodes");
        this.getCommandLine().addToggleSwitch("xml");
        this.getCommandLine().addToggleSwitch("minimize");
        this.getCommandLine().addToggleSwitch("maximize");
        this.getCommandLine().addToggleSwitch("copy-only");
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        exceptions.addAll(this.validateCommandLineForScoping());
        exceptions.addAll(this.validateCommandLineForFiltering());
        if (this.getCommandLine().getToggleSwitch("maximize") && this.getCommandLine().getToggleSwitch("minimize")) {
            exceptions.add(new CommandLineException("Only one of -maximize or -minimize is allowed"));
        }
        return exceptions;
    }

    @Override
    protected void doProcessing() throws Exception {
        SelectionCriteria scopeCriteria = this.getScopeCriteria();
        SelectionCriteria filterCriteria = this.getFilterCriteria();
        GraphCopier copier = this.getCommandLine().getToggleSwitch("copy-only") || this.getCommandLine().getToggleSwitch("maximize") ? new GraphCopier(new SelectiveTraversalStrategy(scopeCriteria, filterCriteria)) : new GraphSummarizer(scopeCriteria, filterCriteria);
        this.copyGraph(copier);
        this.getVerboseListener().print("Printing the graph ...");
        Printer printer = this.getCommandLine().isPresent("xml") ? new XMLPrinter(this.getOut(), this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix")) : new TextPrinter(this.getOut());
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        if (this.getCommandLine().isPresent("show-inbounds") || this.getCommandLine().isPresent("show-outbounds") || this.getCommandLine().isPresent("show-empty-nodes")) {
            printer.setShowInbounds(this.getCommandLine().isPresent("show-inbounds"));
            printer.setShowOutbounds(this.getCommandLine().isPresent("show-outbounds"));
            printer.setShowEmptyNodes(this.getCommandLine().isPresent("show-empty-nodes"));
        }
        printer.traverseNodes(copier.getScopeFactory().getPackages().values());
    }

    private void copyGraph(Visitor copier) throws IOException, SAXException, ParserConfigurationException {
        if (this.getCommandLine().getParameters().isEmpty()) {
            this.copyGraphFromSystemIn(copier);
        } else {
            this.copyGraphFromFiles(copier);
        }
    }

    private void copyGraphFromSystemIn(Visitor copier) throws IOException, ParserConfigurationException, SAXException {
        this.copyGraph(copier, this.loadGraphFromSystemIn());
    }

    private void copyGraphFromFiles(Visitor copier) throws IOException, SAXException, ParserConfigurationException {
        for (String filename : this.getCommandLine().getParameters()) {
            if (filename.endsWith(".xml")) {
                this.copyGraph(copier, this.loadGraphFromFile(filename));
                continue;
            }
            this.getVerboseListener().print("Skipping \"" + filename + "\".");
        }
    }

    private void copyGraph(Visitor copier, Collection<PackageNode> packages) {
        if (this.getCommandLine().getToggleSwitch("maximize")) {
            new LinkMaximizer().traverseNodes(packages);
        } else if (this.getCommandLine().getToggleSwitch("minimize")) {
            new LinkMinimizer().traverseNodes(packages);
        }
        copier.traverseNodes(packages);
    }

    private Collection<PackageNode> loadGraphFromSystemIn() throws IOException, SAXException, ParserConfigurationException {
        this.getVerboseListener().print("Reading from standard input");
        NodeLoader loader = new NodeLoader(this.getCommandLine().getToggleSwitch("validate"));
        loader.addDependencyListener(this.getVerboseListener());
        Collection<PackageNode> packages = loader.load(System.in).getPackages().values();
        this.getVerboseListener().print("Read from standard input.");
        return packages;
    }

    private Collection<PackageNode> loadGraphFromFile(String filename) throws IOException, SAXException, ParserConfigurationException {
        this.getVerboseListener().print("Reading " + filename);
        NodeLoader loader = new NodeLoader(this.getCommandLine().getToggleSwitch("validate"));
        loader.addDependencyListener(this.getVerboseListener());
        Collection<PackageNode> packages = loader.load(filename).getPackages().values();
        this.getVerboseListener().print("Read \"" + filename + "\".");
        return packages;
    }

    public static void main(String[] args) throws Exception {
        new DependencyReporter().run(args);
    }
}

