/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileLoaderEventSource;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.commandline.CommandLineException;
import com.jeantessier.dependencyfinder.cli.DirectoryExplorerCommand;
import com.jeantessier.metrics.CSVPrinter;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.MetricsComparator;
import com.jeantessier.metrics.MetricsConfigurationLoader;
import com.jeantessier.metrics.MetricsFactory;
import com.jeantessier.metrics.MetricsGatherer;
import com.jeantessier.metrics.TextPrinter;
import com.jeantessier.metrics.XMLPrinter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class OOMetrics
extends DirectoryExplorerCommand {
    public static final String DEFAULT_PROJECT_NAME = "Project";
    public static final String DEFAULT_SORT = "name";

    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.populateCommandLineSwitchesForXMLOutput("utf-8", "http://depfind.sourceforge.net/dtd", "    ");
        this.getCommandLine().addSingleValueSwitch("project-name", DEFAULT_PROJECT_NAME);
        this.getCommandLine().addSingleValueSwitch("default-configuration", true);
        this.getCommandLine().addSingleValueSwitch("configuration");
        this.getCommandLine().addToggleSwitch("csv");
        this.getCommandLine().addToggleSwitch("txt");
        this.getCommandLine().addToggleSwitch("xml");
        this.getCommandLine().addToggleSwitch("validate");
        this.getCommandLine().addToggleSwitch("project");
        this.getCommandLine().addToggleSwitch("groups");
        this.getCommandLine().addToggleSwitch("classes");
        this.getCommandLine().addToggleSwitch("methods");
        this.getCommandLine().addMultipleValuesSwitch("scope-includes-list");
        this.getCommandLine().addMultipleValuesSwitch("scope-excludes-list");
        this.getCommandLine().addMultipleValuesSwitch("filter-includes-list");
        this.getCommandLine().addMultipleValuesSwitch("filter-excludes-list");
        this.getCommandLine().addToggleSwitch("show-all-metrics");
        this.getCommandLine().addToggleSwitch("show-empty-metrics");
        this.getCommandLine().addToggleSwitch("show-hidden-measurements");
        this.getCommandLine().addSingleValueSwitch("sort", DEFAULT_SORT);
        this.getCommandLine().addToggleSwitch("expand");
        this.getCommandLine().addToggleSwitch("reverse");
        this.getCommandLine().addToggleSwitch("enable-cross-class-measurements");
    }

    @Override
    protected Collection<CommandLineException> parseCommandLine(String[] args) {
        Collection<CommandLineException> exceptions = super.parseCommandLine(args);
        if (!(this.getCommandLine().isPresent("project") || this.getCommandLine().isPresent("groups") || this.getCommandLine().isPresent("classes") || this.getCommandLine().isPresent("methods"))) {
            this.getCommandLine().getSwitch("project").setValue(true);
            this.getCommandLine().getSwitch("groups").setValue(true);
            this.getCommandLine().getSwitch("classes").setValue(true);
            this.getCommandLine().getSwitch("methods").setValue(true);
        }
        int modeSwitch = 0;
        if (this.getCommandLine().getToggleSwitch("csv")) {
            ++modeSwitch;
        }
        if (this.getCommandLine().getToggleSwitch("txt")) {
            ++modeSwitch;
        }
        if (this.getCommandLine().getToggleSwitch("xml")) {
            ++modeSwitch;
        }
        if (modeSwitch != 1) {
            exceptions.add(new CommandLineException("Must have one and only one of -csv, -txt, or -xml"));
        }
        return exceptions;
    }

    @Override
    protected void doProcessing() throws Exception {
        ClassfileLoaderEventSource loader;
        Logger.getLogger(OOMetrics.class).debug((Object)"Reading configuration ...");
        this.getVerboseListener().print("Reading configuration ...");
        String projectName = this.getCommandLine().getSingleSwitch("project-name");
        MetricsFactory factory = this.getCommandLine().isPresent("configuration") ? new MetricsFactory(projectName, new MetricsConfigurationLoader(this.getCommandLine().getToggleSwitch("validate")).load(this.getCommandLine().getSingleSwitch("configuration"))) : new MetricsFactory(projectName, new MetricsConfigurationLoader(this.getCommandLine().getToggleSwitch("validate")).load(this.getCommandLine().getSingleSwitch("default-configuration")));
        MetricsGatherer gatherer = new MetricsGatherer(factory);
        if (this.getCommandLine().isPresent("scope-includes-list") || this.getCommandLine().isPresent("scope-excludes-list")) {
            gatherer.setScopeIncludes(OOMetrics.createCollection(this.getCommandLine().getMultipleSwitch("scope-includes-list"), this.getCommandLine().getMultipleSwitch("scope-excludes-list")));
        }
        if (this.getCommandLine().isPresent("filter-includes-list") || this.getCommandLine().isPresent("filter-excludes-list")) {
            gatherer.setFilterIncludes(OOMetrics.createCollection(this.getCommandLine().getMultipleSwitch("filter-includes-list"), this.getCommandLine().getMultipleSwitch("filter-excludes-list")));
        }
        gatherer.addMetricsListener(this.getVerboseListener());
        if (this.getCommandLine().isPresent("enable-cross-class-measurements")) {
            Logger.getLogger(OOMetrics.class).debug((Object)"Reading in all classes ...");
            this.getVerboseListener().print("Reading in all classes ...");
            loader = new AggregatingClassfileLoader();
            ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
            loader.load(this.getCommandLine().getParameters());
            Logger.getLogger(OOMetrics.class).debug((Object)"Computing metrics ...");
            this.getVerboseListener().print("Computing metrics ...");
            gatherer.visitClassfiles(loader.getAllClassfiles());
        } else {
            loader = new TransientClassfileLoader();
            ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
            ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(gatherer));
            Logger.getLogger(OOMetrics.class).debug((Object)"Reading classes and computing metrics as we go ...");
            this.getVerboseListener().print("Reading classes and computing metrics as we go ...");
            loader.load(this.getCommandLine().getParameters());
        }
        if (this.getCommandLine().isPresent("show-all-metrics")) {
            Iterator<Metrics> i = gatherer.getMetricsFactory().getAllClassMetrics().iterator();
            while (i.hasNext()) {
                gatherer.getMetricsFactory().includeClassMetrics(i.next());
            }
            i = gatherer.getMetricsFactory().getAllMethodMetrics().iterator();
            while (i.hasNext()) {
                gatherer.getMetricsFactory().includeMethodMetrics(i.next());
            }
        }
        Logger.getLogger(OOMetrics.class).debug((Object)"Printing results ...");
        this.getVerboseListener().print("Printing results ...");
        if (this.getCommandLine().isPresent("csv")) {
            this.printCSVFiles(gatherer.getMetricsFactory());
        } else if (this.getCommandLine().isPresent("txt")) {
            this.printTextFile(gatherer.getMetricsFactory());
        } else if (this.getCommandLine().isPresent("xml")) {
            this.printXMLFile(gatherer.getMetricsFactory());
        }
        Logger.getLogger(OOMetrics.class).debug((Object)"Done.");
    }

    private static Collection<String> createCollection(Collection<String> includes, Collection<String> excludes) throws IOException {
        String line;
        BufferedReader reader;
        HashSet<String> result = new HashSet<String>();
        for (String include : includes) {
            reader = new BufferedReader(new FileReader(include));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
            reader.close();
        }
        for (String exclude : excludes) {
            reader = new BufferedReader(new FileReader(exclude));
            while ((line = reader.readLine()) != null) {
                result.remove(line);
            }
            reader.close();
        }
        return result;
    }

    private void printCSVFiles(MetricsFactory factory) throws IOException {
        CSVPrinter printer;
        ArrayList<Metrics> metrics;
        MetricsComparator comparator = new MetricsComparator(this.getCommandLine().getSingleSwitch("sort"));
        if (this.getCommandLine().getToggleSwitch("reverse")) {
            comparator.reverse();
        }
        if (this.getCommandLine().getToggleSwitch("project")) {
            if (this.getCommandLine().isPresent("out")) {
                this.setOut(new PrintWriter(new FileWriter(this.getCommandLine().getSingleSwitch("out") + "_project.csv")));
            } else {
                this.getOut().println("Project:");
            }
            metrics = new ArrayList<Metrics>(factory.getProjectMetrics());
            Collections.sort(metrics, comparator);
            printer = new CSVPrinter(this.getOut(), factory.getConfiguration().getProjectMeasurements());
            printer.setShowEmptyMetrics(this.getCommandLine().isPresent("show-empty-metrics"));
            printer.setShowHiddenMeasurements(this.getCommandLine().isPresent("show-hidden-measurements"));
            if (this.getCommandLine().isPresent("indent-text")) {
                printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
            }
            printer.visitMetrics(metrics);
            if (this.getCommandLine().isPresent("out")) {
                this.getOut().close();
            } else {
                this.getOut().println();
            }
        }
        if (this.getCommandLine().getToggleSwitch("groups")) {
            if (this.getCommandLine().isPresent("out")) {
                this.setOut(new PrintWriter(new FileWriter(this.getCommandLine().getSingleSwitch("out") + "_groups.csv")));
            } else {
                this.getOut().println("Packages:");
            }
            metrics = new ArrayList<Metrics>(factory.getGroupMetrics());
            Collections.sort(metrics, comparator);
            printer = new CSVPrinter(this.getOut(), factory.getConfiguration().getGroupMeasurements());
            printer.setShowEmptyMetrics(this.getCommandLine().isPresent("show-empty-metrics"));
            printer.setShowHiddenMeasurements(this.getCommandLine().isPresent("show-hidden-measurements"));
            if (this.getCommandLine().isPresent("indent-text")) {
                printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
            }
            printer.visitMetrics(metrics);
            if (this.getCommandLine().isPresent("out")) {
                this.getOut().close();
            } else {
                this.getOut().println();
            }
        }
        if (this.getCommandLine().getToggleSwitch("classes")) {
            if (this.getCommandLine().isPresent("out")) {
                this.setOut(new PrintWriter(new FileWriter(this.getCommandLine().getSingleSwitch("out") + "_classes.csv")));
            } else {
                this.getOut().println("Classes:");
            }
            metrics = new ArrayList<Metrics>(factory.getClassMetrics());
            Collections.sort(metrics, comparator);
            printer = new CSVPrinter(this.getOut(), factory.getConfiguration().getClassMeasurements());
            printer.setShowEmptyMetrics(this.getCommandLine().isPresent("show-empty-metrics"));
            printer.setShowHiddenMeasurements(this.getCommandLine().isPresent("show-hidden-measurements"));
            if (this.getCommandLine().isPresent("indent-text")) {
                printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
            }
            printer.visitMetrics(metrics);
            if (this.getCommandLine().isPresent("out")) {
                this.getOut().close();
            } else {
                this.getOut().println();
            }
        }
        if (this.getCommandLine().getToggleSwitch("methods")) {
            if (this.getCommandLine().isPresent("out")) {
                this.setOut(new PrintWriter(new FileWriter(this.getCommandLine().getSingleSwitch("out") + "_methods.csv")));
            } else {
                this.getOut().println("Methods:");
            }
            metrics = new ArrayList<Metrics>(factory.getMethodMetrics());
            Collections.sort(metrics, comparator);
            printer = new CSVPrinter(this.getOut(), factory.getConfiguration().getMethodMeasurements());
            printer.setShowEmptyMetrics(this.getCommandLine().isPresent("show-empty-metrics"));
            printer.setShowHiddenMeasurements(this.getCommandLine().isPresent("show-hidden-measurements"));
            if (this.getCommandLine().isPresent("indent-text")) {
                printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
            }
            printer.visitMetrics(metrics);
            if (this.getCommandLine().isPresent("out")) {
                this.getOut().close();
            }
        }
    }

    private void printTextFile(MetricsFactory factory) throws IOException {
        TextPrinter printer;
        ArrayList<Metrics> metrics;
        MetricsComparator comparator = new MetricsComparator(this.getCommandLine().getSingleSwitch("sort"));
        if (this.getCommandLine().getToggleSwitch("reverse")) {
            comparator.reverse();
        }
        if (this.getCommandLine().getToggleSwitch("project")) {
            this.getOut().println("Project metrics");
            this.getOut().println("---------------");
            metrics = new ArrayList<Metrics>(factory.getProjectMetrics());
            Collections.sort(metrics, comparator);
            printer = new TextPrinter(this.getOut(), factory.getConfiguration().getProjectMeasurements());
            printer.setExpandCollectionMeasurements(this.getCommandLine().getToggleSwitch("expand"));
            printer.setShowEmptyMetrics(this.getCommandLine().isPresent("show-empty-metrics"));
            printer.setShowHiddenMeasurements(this.getCommandLine().isPresent("show-hidden-measurements"));
            if (this.getCommandLine().isPresent("indent-text")) {
                printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
            }
            printer.visitMetrics(metrics);
            this.getOut().println();
        }
        if (this.getCommandLine().getToggleSwitch("groups")) {
            this.getOut().println("Group metrics");
            this.getOut().println("-------------");
            metrics = new ArrayList<Metrics>(factory.getGroupMetrics());
            Collections.sort(metrics, comparator);
            printer = new TextPrinter(this.getOut(), factory.getConfiguration().getGroupMeasurements());
            printer.setExpandCollectionMeasurements(this.getCommandLine().getToggleSwitch("expand"));
            printer.setShowEmptyMetrics(this.getCommandLine().isPresent("show-empty-metrics"));
            printer.setShowHiddenMeasurements(this.getCommandLine().isPresent("show-hidden-measurements"));
            if (this.getCommandLine().isPresent("indent-text")) {
                printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
            }
            printer.visitMetrics(metrics);
            this.getOut().println();
        }
        if (this.getCommandLine().getToggleSwitch("classes")) {
            this.getOut().println("Class metrics");
            this.getOut().println("-------------");
            metrics = new ArrayList<Metrics>(factory.getClassMetrics());
            Collections.sort(metrics, comparator);
            printer = new TextPrinter(this.getOut(), factory.getConfiguration().getClassMeasurements());
            printer.setExpandCollectionMeasurements(this.getCommandLine().getToggleSwitch("expand"));
            printer.setShowEmptyMetrics(this.getCommandLine().isPresent("show-empty-metrics"));
            printer.setShowHiddenMeasurements(this.getCommandLine().isPresent("show-hidden-measurements"));
            if (this.getCommandLine().isPresent("indent-text")) {
                printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
            }
            printer.visitMetrics(metrics);
            this.getOut().println();
        }
        if (this.getCommandLine().getToggleSwitch("methods")) {
            this.getOut().println("Method metrics");
            this.getOut().println("--------------");
            metrics = new ArrayList<Metrics>(factory.getMethodMetrics());
            Collections.sort(metrics, comparator);
            printer = new TextPrinter(this.getOut(), factory.getConfiguration().getMethodMeasurements());
            printer.setExpandCollectionMeasurements(this.getCommandLine().getToggleSwitch("expand"));
            printer.setShowEmptyMetrics(this.getCommandLine().isPresent("show-empty-metrics"));
            printer.setShowHiddenMeasurements(this.getCommandLine().isPresent("show-hidden-measurements"));
            if (this.getCommandLine().isPresent("indent-text")) {
                printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
            }
            printer.visitMetrics(metrics);
            this.getOut().println();
        }
        this.getOut().close();
    }

    private void printXMLFile(MetricsFactory factory) throws IOException {
        MetricsComparator comparator = new MetricsComparator(this.getCommandLine().getSingleSwitch("sort"));
        if (this.getCommandLine().getToggleSwitch("reverse")) {
            comparator.reverse();
        }
        ArrayList<Metrics> metrics = new ArrayList<Metrics>(factory.getProjectMetrics());
        Collections.sort(metrics, comparator);
        XMLPrinter printer = new XMLPrinter(this.getOut(), factory.getConfiguration(), this.getCommandLine().getSingleSwitch("encoding"), this.getCommandLine().getSingleSwitch("dtd-prefix"));
        printer.setShowEmptyMetrics(this.getCommandLine().isPresent("show-empty-metrics"));
        printer.setShowHiddenMeasurements(this.getCommandLine().isPresent("show-hidden-measurements"));
        if (this.getCommandLine().isPresent("indent-text")) {
            printer.setIndentText(this.getCommandLine().getSingleSwitch("indent-text"));
        }
        printer.visitMetrics(metrics);
        this.getOut().close();
    }

    public static void main(String[] args) throws Exception {
        new OOMetrics().run(args);
    }
}

