/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.webwork;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileLoaderEventSource;
import com.jeantessier.classreader.ModifiedOnlyDispatcher;
import com.jeantessier.classreader.Monitor;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependency.CodeDependencyCollector;
import com.jeantessier.dependency.DeletingVisitor;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependencyfinder.webwork.ActionBase;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExtractAction
extends ActionBase {
    private static final SimpleDateFormat START_DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Date start;
    private Date stop;

    public Date getStart() {
        return this.start;
    }

    public Date getStop() {
        return this.stop;
    }

    public double getDurationInSecs() {
        return (double)(this.stop.getTime() - this.start.getTime()) / 1000.0;
    }

    public String execute() throws Exception {
        return "input";
    }

    public String doUpdate() {
        this.start = new Date();
        this.extractGraph();
        this.stop = new Date();
        this.application.put("updateStart", this.getStartText());
        this.application.put("updateDuration", this.getDurationInSecs());
        this.application.remove("loadStart");
        this.application.remove("loadDuration");
        return "success";
    }

    public String doExtract() {
        this.start = new Date();
        this.dispatcher = new ModifiedOnlyDispatcher(ClassfileLoaderEventSource.DEFAULT_DISPATCHER);
        this.factory = new NodeFactory();
        CodeDependencyCollector collector = new CodeDependencyCollector(this.factory);
        DeletingVisitor deletingVisitor = new DeletingVisitor(this.factory);
        this.monitor = new Monitor(collector, deletingVisitor);
        this.extractGraph();
        this.stop = new Date();
        this.application.put("dispatcher", this.dispatcher);
        this.application.put("factory", this.factory);
        this.application.put("monitor", this.monitor);
        this.application.put("extractStart", this.getStartText());
        this.application.put("extractDuration", this.getDurationInSecs());
        this.application.remove("updateStart");
        this.application.remove("updateDuration");
        this.application.remove("loadStart");
        this.application.remove("loadDuration");
        return "success";
    }

    private String getStartText() {
        return START_DATE_FORMATTER.format(this.start);
    }

    private void extractGraph() {
        TransientClassfileLoader loader = new TransientClassfileLoader(this.dispatcher);
        ((ClassfileLoader)loader).addLoadListener(this.monitor);
        loader.load(this.getSources());
        if ("maximize".equalsIgnoreCase(this.mode)) {
            new LinkMaximizer().traverseNodes(this.factory.getPackages().values());
        } else if ("minimize".equalsIgnoreCase(this.mode)) {
            new LinkMinimizer().traverseNodes(this.factory.getPackages().values());
        }
    }
}

