/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.classreader.Annotation;
import com.jeantessier.classreader.AnnotationDefault_attribute;
import com.jeantessier.classreader.AnnotationElementValue;
import com.jeantessier.classreader.ArrayElementValue;
import com.jeantessier.classreader.BooleanConstantElementValue;
import com.jeantessier.classreader.ByteConstantElementValue;
import com.jeantessier.classreader.CharConstantElementValue;
import com.jeantessier.classreader.ClassElementValue;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.ConstantPool;
import com.jeantessier.classreader.ConstantValue_attribute;
import com.jeantessier.classreader.Custom_attribute;
import com.jeantessier.classreader.Deprecated_attribute;
import com.jeantessier.classreader.DoubleConstantElementValue;
import com.jeantessier.classreader.Double_info;
import com.jeantessier.classreader.ElementValuePair;
import com.jeantessier.classreader.EnclosingMethod_attribute;
import com.jeantessier.classreader.EnumElementValue;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.Exceptions_attribute;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.FloatConstantElementValue;
import com.jeantessier.classreader.Float_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.InnerClasses_attribute;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.IntegerConstantElementValue;
import com.jeantessier.classreader.Integer_info;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.LineNumber;
import com.jeantessier.classreader.LineNumberTable_attribute;
import com.jeantessier.classreader.LocalVariable;
import com.jeantessier.classreader.LocalVariableTable_attribute;
import com.jeantessier.classreader.LocalVariableType;
import com.jeantessier.classreader.LocalVariableTypeTable_attribute;
import com.jeantessier.classreader.LongConstantElementValue;
import com.jeantessier.classreader.Long_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.NameAndType_info;
import com.jeantessier.classreader.Parameter;
import com.jeantessier.classreader.RuntimeInvisibleAnnotations_attribute;
import com.jeantessier.classreader.RuntimeInvisibleParameterAnnotations_attribute;
import com.jeantessier.classreader.RuntimeVisibleAnnotations_attribute;
import com.jeantessier.classreader.RuntimeVisibleParameterAnnotations_attribute;
import com.jeantessier.classreader.ShortConstantElementValue;
import com.jeantessier.classreader.Signature_attribute;
import com.jeantessier.classreader.SourceDebugExtension_attribute;
import com.jeantessier.classreader.SourceFile_attribute;
import com.jeantessier.classreader.StringConstantElementValue;
import com.jeantessier.classreader.String_info;
import com.jeantessier.classreader.Synthetic_attribute;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.diff.ClassDifferences;
import com.jeantessier.diff.CodeDifferences;
import com.jeantessier.diff.ConstructorDifferences;
import com.jeantessier.diff.Differences;
import com.jeantessier.diff.FeatureDifferences;
import com.jeantessier.diff.FieldDifferences;
import com.jeantessier.diff.InterfaceDifferences;
import com.jeantessier.diff.MethodDifferences;
import com.jeantessier.diff.Printer;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.oro.text.perl.Perl5Util;

public class ClassReport
extends Printer
implements Comparable,
Visitor {
    private static final Perl5Util perl = new Perl5Util();
    private ClassDifferences differences;
    private Collection<FeatureDifferences> removedFields = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> removedConstructors = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> removedMethods = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> deprecatedFields = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> deprecatedConstructors = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> deprecatedMethods = new TreeSet<FeatureDifferences>();
    private Collection<FieldDifferences> modifiedFields = new TreeSet<FieldDifferences>();
    private Collection<CodeDifferences> modifiedConstructors = new TreeSet<CodeDifferences>();
    private Collection<CodeDifferences> modifiedMethods = new TreeSet<CodeDifferences>();
    private Collection<FeatureDifferences> undeprecatedFields = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> undeprecatedConstructors = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> undeprecatedMethods = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> newFields = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> newConstructors = new TreeSet<FeatureDifferences>();
    private Collection<FeatureDifferences> newMethods = new TreeSet<FeatureDifferences>();

    @Override
    public void visitClassDifferences(ClassDifferences differences) {
        this.differences = differences;
        for (Differences featureDifference : differences.getFeatureDifferences()) {
            featureDifference.accept(this);
        }
    }

    @Override
    public void visitInterfaceDifferences(InterfaceDifferences differences) {
        this.differences = differences;
        for (Differences featureDifference : differences.getFeatureDifferences()) {
            featureDifference.accept(this);
        }
    }

    @Override
    public void visitFieldDifferences(FieldDifferences differences) {
        if (differences.isRemoved()) {
            this.removedFields.add(differences);
        }
        if (differences.isModified()) {
            this.modifiedFields.add(differences);
        }
        if (differences.isNew()) {
            this.newFields.add(differences);
        }
        if (this.isDeprecated()) {
            this.deprecatedFields.add(differences);
        }
        if (this.isUndeprecated()) {
            this.undeprecatedFields.add(differences);
        }
    }

    @Override
    public void visitConstructorDifferences(ConstructorDifferences differences) {
        if (differences.isRemoved()) {
            this.removedConstructors.add(differences);
        }
        if (differences.isModified()) {
            this.modifiedConstructors.add(differences);
        }
        if (differences.isNew()) {
            this.newConstructors.add(differences);
        }
        if (this.isDeprecated()) {
            this.deprecatedConstructors.add(differences);
        }
        if (this.isUndeprecated()) {
            this.undeprecatedConstructors.add(differences);
        }
    }

    @Override
    public void visitMethodDifferences(MethodDifferences differences) {
        if (differences.isRemoved()) {
            this.removedMethods.add(differences);
        }
        if (differences.isModified()) {
            this.modifiedMethods.add(differences);
        }
        if (differences.isNew()) {
            this.newMethods.add(differences);
        }
        if (this.isDeprecated()) {
            this.deprecatedMethods.add(differences);
        }
        if (this.isUndeprecated()) {
            this.undeprecatedMethods.add(differences);
        }
    }

    @Override
    public void visitClassfiles(Collection<Classfile> classfiles) {
    }

    @Override
    public void visitClassfile(Classfile classfile) {
    }

    @Override
    public void visitConstantPool(ConstantPool constantPool) {
    }

    @Override
    public void visitClass_info(Class_info entry) {
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
    }

    @Override
    public void visitString_info(String_info entry) {
        entry.getRawValue().accept(this);
    }

    @Override
    public void visitInteger_info(Integer_info entry) {
        this.append(entry.getValue());
    }

    @Override
    public void visitFloat_info(Float_info entry) {
        this.append(entry.getValue());
    }

    @Override
    public void visitLong_info(Long_info entry) {
        this.append(entry.getValue());
    }

    @Override
    public void visitDouble_info(Double_info entry) {
        this.append(entry.getValue());
    }

    @Override
    public void visitNameAndType_info(NameAndType_info entry) {
    }

    @Override
    public void visitUTF8_info(UTF8_info entry) {
        this.append(this.escapeXMLCharactersInAttributeValue(entry.getValue()));
    }

    @Override
    public void visitField_info(Field_info entry) {
        if (entry.isPublic()) {
            this.append(" visibility=\"public\"");
        }
        if (entry.isProtected()) {
            this.append(" visibility=\"protected\"");
        }
        if (entry.isPackage()) {
            this.append(" visibility=\"package\"");
        }
        if (entry.isPrivate()) {
            this.append(" visibility=\"private\"");
        }
        if (entry.isStatic()) {
            this.append(" static=\"yes\"");
        }
        if (entry.isFinal()) {
            this.append(" final=\"yes\"");
        }
        if (entry.isVolatile()) {
            this.append(" volatile=\"yes\"");
        }
        if (entry.isTransient()) {
            this.append(" transient=\"yes\"");
        }
        if (entry.isSynthetic()) {
            this.append(" synthetic=\"yes\"");
        }
        if (entry.isDeprecated()) {
            this.append(" deprecated=\"yes\"");
        }
        this.append(" type=\"").append(entry.getType()).append("\"");
        this.append(" name=\"").append(entry.getName()).append("\"");
        this.append(" signature=\"").append(entry.getSignature()).append("\"");
        this.append(" full-signature=\"").append(entry.getFullSignature()).append("\"");
        if (entry.getConstantValue() != null) {
            this.append(" value=\"");
            entry.getConstantValue().accept(this);
            this.append("\"");
        }
    }

    @Override
    public void visitMethod_info(Method_info entry) {
    }

    @Override
    public void visitConstantValue_attribute(ConstantValue_attribute attribute) {
        attribute.getRawValue().accept(this);
    }

    @Override
    public void visitCode_attribute(Code_attribute attribute) {
    }

    @Override
    public void visitExceptions_attribute(Exceptions_attribute attribute) {
    }

    @Override
    public void visitInnerClasses_attribute(InnerClasses_attribute attribute) {
    }

    @Override
    public void visitEnclosingMethod_attribute(EnclosingMethod_attribute attribute) {
    }

    @Override
    public void visitSynthetic_attribute(Synthetic_attribute attribute) {
    }

    @Override
    public void visitSignature_attribute(Signature_attribute attribute) {
    }

    @Override
    public void visitSourceFile_attribute(SourceFile_attribute attribute) {
    }

    @Override
    public void visitSourceDebugExtension_attribute(SourceDebugExtension_attribute attribute) {
    }

    @Override
    public void visitLineNumberTable_attribute(LineNumberTable_attribute attribute) {
    }

    @Override
    public void visitLocalVariableTable_attribute(LocalVariableTable_attribute attribute) {
    }

    @Override
    public void visitLocalVariableTypeTable_attribute(LocalVariableTypeTable_attribute attribute) {
    }

    @Override
    public void visitDeprecated_attribute(Deprecated_attribute attribute) {
    }

    @Override
    public void visitRuntimeVisibleAnnotations_attribute(RuntimeVisibleAnnotations_attribute attribute) {
    }

    @Override
    public void visitRuntimeInvisibleAnnotations_attribute(RuntimeInvisibleAnnotations_attribute attribute) {
    }

    @Override
    public void visitRuntimeVisibleParameterAnnotations_attribute(RuntimeVisibleParameterAnnotations_attribute attribute) {
    }

    @Override
    public void visitRuntimeInvisibleParameterAnnotations_attribute(RuntimeInvisibleParameterAnnotations_attribute attribute) {
    }

    @Override
    public void visitAnnotationDefault_attribute(AnnotationDefault_attribute attribute) {
    }

    @Override
    public void visitCustom_attribute(Custom_attribute attribute) {
    }

    @Override
    public void visitInstruction(Instruction instruction) {
    }

    @Override
    public void visitExceptionHandler(ExceptionHandler helper) {
    }

    @Override
    public void visitInnerClass(InnerClass helper) {
    }

    @Override
    public void visitLineNumber(LineNumber helper) {
    }

    @Override
    public void visitLocalVariable(LocalVariable helper) {
    }

    @Override
    public void visitLocalVariableType(LocalVariableType helper) {
    }

    @Override
    public void visitParameter(Parameter helper) {
    }

    @Override
    public void visitAnnotation(Annotation helper) {
    }

    @Override
    public void visitElementValuePair(ElementValuePair helper) {
    }

    @Override
    public void visitByteConstantElementValue(ByteConstantElementValue helper) {
    }

    @Override
    public void visitCharConstantElementValue(CharConstantElementValue helper) {
    }

    @Override
    public void visitDoubleConstantElementValue(DoubleConstantElementValue helper) {
    }

    @Override
    public void visitFloatConstantElementValue(FloatConstantElementValue helper) {
    }

    @Override
    public void visitIntegerConstantElementValue(IntegerConstantElementValue helper) {
    }

    @Override
    public void visitLongConstantElementValue(LongConstantElementValue helper) {
    }

    @Override
    public void visitShortConstantElementValue(ShortConstantElementValue helper) {
    }

    @Override
    public void visitBooleanConstantElementValue(BooleanConstantElementValue helper) {
    }

    @Override
    public void visitStringConstantElementValue(StringConstantElementValue helper) {
    }

    @Override
    public void visitEnumElementValue(EnumElementValue helper) {
    }

    @Override
    public void visitClassElementValue(ClassElementValue helper) {
    }

    @Override
    public void visitAnnotationElementValue(AnnotationElementValue helper) {
    }

    @Override
    public void visitArrayElementValue(ArrayElementValue helper) {
    }

    public String render() {
        this.raiseIndent();
        this.raiseIndent();
        this.indent().append("<class>").eol();
        this.raiseIndent();
        this.indent().append("<name>").append(this.differences.getName()).append("</name>").eol();
        if (this.differences.isDeclarationModified()) {
            this.indent().append("<modified-declaration>").eol();
            this.raiseIndent();
            this.indent().append("<old-declaration").append(this.breakdownDeclaration(this.differences.getOldClass())).append(">").append(this.differences.getOldDeclaration()).append("</old-declaration>").eol();
            this.indent().append("<new-declaration").append(this.breakdownDeclaration(this.differences.getNewClass())).append(">").append(this.differences.getNewDeclaration()).append("</new-declaration>").eol();
            this.lowerIndent();
            this.indent().append("</modified-declaration>").eol();
        }
        if (this.removedFields.size() != 0) {
            this.indent().append("<removed-fields>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.removedFields) {
                this.indent();
                this.append("<declaration");
                featureDifferences.getOldFeature().accept(this);
                if (featureDifferences.isInherited()) {
                    this.append(" inherited=\"yes\"");
                }
                this.append(">");
                this.append(featureDifferences.getOldDeclaration());
                this.append("</declaration>");
                this.eol();
            }
            this.lowerIndent();
            this.indent().append("</removed-fields>").eol();
        }
        if (this.removedConstructors.size() != 0) {
            this.indent().append("<removed-constructors>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.removedConstructors) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getOldFeature())).append(featureDifferences.isInherited() ? " inherited=\"yes\"" : "").append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</removed-constructors>").eol();
        }
        if (this.removedMethods.size() != 0) {
            this.indent().append("<removed-methods>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.removedMethods) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getOldFeature())).append(featureDifferences.isInherited() ? " inherited=\"yes\"" : "").append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</removed-methods>").eol();
        }
        if (this.deprecatedFields.size() != 0) {
            this.indent().append("<deprecated-fields>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.deprecatedFields) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Field_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</deprecated-fields>").eol();
        }
        if (this.deprecatedConstructors.size() != 0) {
            this.indent().append("<deprecated-constructors>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.deprecatedConstructors) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</deprecated-constructors>").eol();
        }
        if (this.deprecatedMethods.size() != 0) {
            this.indent().append("<deprecated-methods>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.deprecatedMethods) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</deprecated-methods>").eol();
        }
        if (this.modifiedFields.size() != 0) {
            this.indent().append("<modified-fields>").eol();
            this.raiseIndent();
            for (FieldDifferences fieldDifferences : this.modifiedFields) {
                this.indent().append("<feature>").eol();
                this.raiseIndent();
                this.indent().append("<name>").append(fieldDifferences.getName()).append("</name>").eol();
                this.indent().append("<modified-declaration>").eol();
                this.raiseIndent();
                Field_info oldField = (Field_info)fieldDifferences.getOldFeature();
                this.indent();
                this.append("<old-declaration");
                oldField.accept(this);
                this.append(">");
                if (fieldDifferences.isConstantValueDifference()) {
                    this.append(this.escapeXMLCharactersInTagContent(oldField.getFullDeclaration()));
                } else {
                    this.append(oldField.getDeclaration());
                }
                this.append("</old-declaration>");
                this.eol();
                Field_info newField = (Field_info)fieldDifferences.getNewFeature();
                this.indent();
                this.append("<new-declaration");
                newField.accept(this);
                this.append(">");
                if (fieldDifferences.isConstantValueDifference()) {
                    this.append(this.escapeXMLCharactersInTagContent(newField.getFullDeclaration()));
                } else {
                    this.append(newField.getDeclaration());
                }
                this.append("</new-declaration>");
                this.eol();
                this.lowerIndent();
                this.indent().append("</modified-declaration>").eol();
                this.lowerIndent();
                this.indent().append("</feature>").eol();
            }
            this.lowerIndent();
            this.indent().append("</modified-fields>").eol();
        }
        if (this.modifiedConstructors.size() != 0) {
            this.indent().append("<modified-constructors>").eol();
            this.raiseIndent();
            for (CodeDifferences codeDifferences : this.modifiedConstructors) {
                this.indent().append("<feature>").eol();
                this.raiseIndent();
                this.indent().append("<name>").append(codeDifferences.getName()).append("</name>").eol();
                if (!codeDifferences.getOldDeclaration().equals(codeDifferences.getNewDeclaration())) {
                    this.indent().append("<modified-declaration>").eol();
                    this.raiseIndent();
                    this.indent().append("<old-declaration").append(this.breakdownDeclaration((Method_info)codeDifferences.getOldFeature())).append(">").append(codeDifferences.getOldDeclaration()).append("</old-declaration>").eol();
                    this.indent().append("<new-declaration").append(this.breakdownDeclaration((Method_info)codeDifferences.getNewFeature())).append(">").append(codeDifferences.getNewDeclaration()).append("</new-declaration>").eol();
                    this.lowerIndent();
                    this.indent().append("</modified-declaration>").eol();
                }
                if (codeDifferences.isCodeDifference()) {
                    this.indent().append("<modified-code").append(this.breakdownDeclaration((Method_info)codeDifferences.getNewFeature())).append(">").append(codeDifferences.getNewDeclaration()).append("</modified-code>").eol();
                }
                this.lowerIndent();
                this.indent().append("</feature>").eol();
            }
            this.lowerIndent();
            this.indent().append("</modified-constructors>").eol();
        }
        if (this.modifiedMethods.size() != 0) {
            this.indent().append("<modified-methods>").eol();
            this.raiseIndent();
            for (CodeDifferences codeDifferences : this.modifiedMethods) {
                this.indent().append("<feature>").eol();
                this.raiseIndent();
                this.indent().append("<name>").append(codeDifferences.getName()).append("</name>").eol();
                if (!codeDifferences.getOldDeclaration().equals(codeDifferences.getNewDeclaration())) {
                    this.indent().append("<modified-declaration>").eol();
                    this.raiseIndent();
                    this.indent().append("<old-declaration").append(this.breakdownDeclaration((Method_info)codeDifferences.getOldFeature())).append(">").append(codeDifferences.getOldDeclaration()).append("</old-declaration>").eol();
                    this.indent().append("<new-declaration").append(this.breakdownDeclaration((Method_info)codeDifferences.getNewFeature())).append(">").append(codeDifferences.getNewDeclaration()).append("</new-declaration>").eol();
                    this.lowerIndent();
                    this.indent().append("</modified-declaration>").eol();
                }
                if (codeDifferences.isCodeDifference()) {
                    this.indent().append("<modified-code").append(this.breakdownDeclaration((Method_info)codeDifferences.getNewFeature())).append(">").append(codeDifferences.getNewDeclaration()).append("</modified-code>").eol();
                }
                this.lowerIndent();
                this.indent().append("</feature>").eol();
            }
            this.lowerIndent();
            this.indent().append("</modified-methods>").eol();
        }
        if (this.undeprecatedFields.size() != 0) {
            this.indent().append("<undeprecated-fields>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.undeprecatedFields) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Field_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</undeprecated-fields>").eol();
        }
        if (this.undeprecatedConstructors.size() != 0) {
            this.indent().append("<undeprecated-constructors>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.undeprecatedConstructors) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</undeprecated-constructors>").eol();
        }
        if (this.undeprecatedMethods.size() != 0) {
            this.indent().append("<undeprecated-methods>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.undeprecatedMethods) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getOldDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</undeprecated-methods>").eol();
        }
        if (this.newFields.size() != 0) {
            this.indent().append("<new-fields>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.newFields) {
                this.indent();
                this.append("<declaration");
                featureDifferences.getNewFeature().accept(this);
                this.append(">");
                this.append(featureDifferences.getNewDeclaration());
                this.append("</declaration>");
                this.eol();
            }
            this.lowerIndent();
            this.indent().append("</new-fields>").eol();
        }
        if (this.newConstructors.size() != 0) {
            this.indent().append("<new-constructors>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.newConstructors) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getNewDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</new-constructors>").eol();
        }
        if (this.newMethods.size() != 0) {
            this.indent().append("<new-methods>").eol();
            this.raiseIndent();
            for (FeatureDifferences featureDifferences : this.newMethods) {
                this.indent().append("<declaration").append(this.breakdownDeclaration((Method_info)featureDifferences.getNewFeature())).append(">").append(featureDifferences.getNewDeclaration()).append("</declaration>").eol();
            }
            this.lowerIndent();
            this.indent().append("</new-methods>").eol();
        }
        this.lowerIndent();
        this.indent().append("</class>").eol();
        this.lowerIndent();
        this.lowerIndent();
        return super.toString();
    }

    private String breakdownDeclaration(Classfile element) {
        StringBuffer result = new StringBuffer();
        if (element != null) {
            if (element.isPublic()) {
                result.append(" visibility=\"public\"");
            }
            if (element.isPackage()) {
                result.append(" visibility=\"package\"");
            }
            if (element.isFinal()) {
                result.append(" final=\"yes\"");
            }
            if (element.isSuper()) {
                result.append(" super=\"yes\"");
            }
            if (element.isSynthetic()) {
                result.append(" synthetic=\"yes\"");
            }
            if (element.isDeprecated()) {
                result.append(" deprecated=\"yes\"");
            }
            result.append(" name=\"").append(element.getClassName()).append("\"");
            if (element.isInterface()) {
                result.append(" interface=\"yes\"");
                result.append(" extends=\"");
                Iterator<? extends Class_info> i = element.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                result.append("\"");
            } else {
                if (element.isAbstract()) {
                    result.append(" abstract=\"yes\"");
                }
                result.append(" extends=\"").append(element.getSuperclassName()).append("\"");
                result.append(" implements=\"");
                Iterator<? extends Class_info> i = element.getAllInterfaces().iterator();
                while (i.hasNext()) {
                    result.append(i.next());
                    if (!i.hasNext()) continue;
                    result.append(", ");
                }
                result.append("\"");
            }
        }
        return result.toString();
    }

    private String breakdownDeclaration(Field_info element) {
        StringBuffer result = new StringBuffer();
        if (element != null) {
            if (element.isPublic()) {
                result.append(" visibility=\"public\"");
            }
            if (element.isProtected()) {
                result.append(" visibility=\"protected\"");
            }
            if (element.isPackage()) {
                result.append(" visibility=\"package\"");
            }
            if (element.isPrivate()) {
                result.append(" visibility=\"private\"");
            }
            if (element.isStatic()) {
                result.append(" static=\"yes\"");
            }
            if (element.isFinal()) {
                result.append(" final=\"yes\"");
            }
            if (element.isVolatile()) {
                result.append(" volatile=\"yes\"");
            }
            if (element.isTransient()) {
                result.append(" transient=\"yes\"");
            }
            if (element.isSynthetic()) {
                result.append(" synthetic=\"yes\"");
            }
            if (element.isDeprecated()) {
                result.append(" deprecated=\"yes\"");
            }
            result.append(" type=\"").append(element.getType()).append("\"");
            result.append(" name=\"").append(element.getName()).append("\"");
            result.append(" signature=\"").append(element.getSignature()).append("\"");
            result.append(" full-signature=\"").append(element.getFullSignature()).append("\"");
            if (element.getConstantValue() != null) {
                result.append(" value=\"").append(element.getConstantValue().getRawValue()).append("\"");
            }
        }
        return result.toString();
    }

    private String breakdownDeclaration(Method_info element) {
        StringBuffer result = new StringBuffer();
        if (element != null) {
            if (element.isPublic()) {
                result.append(" visibility=\"public\"");
            }
            if (element.isProtected()) {
                result.append(" visibility=\"protected\"");
            }
            if (element.isPackage()) {
                result.append(" visibility=\"package\"");
            }
            if (element.isPrivate()) {
                result.append(" visibility=\"private\"");
            }
            if (element.isStatic()) {
                result.append(" static=\"yes\"");
            }
            if (element.isFinal()) {
                result.append(" final=\"yes\"");
            }
            if (element.isSynchronized()) {
                result.append(" synchronized=\"yes\"");
            }
            if (element.isNative()) {
                result.append(" native=\"yes\"");
            }
            if (element.isAbstract()) {
                result.append(" abstract=\"yes\"");
            }
            if (element.isStrict()) {
                result.append(" strict=\"yes\"");
            }
            if (element.isSynthetic()) {
                result.append(" synthetic=\"yes\"");
            }
            if (element.isDeprecated()) {
                result.append(" deprecated=\"yes\"");
            }
            if (!element.getName().equals("<init>") && !element.getName().equals("<clinit>")) {
                result.append(" return-type=\"").append(element.getReturnType()).append("\"");
            }
            result.append(" signature=\"").append(element.getSignature()).append("\"");
            result.append(" full-signature=\"").append(element.getFullSignature()).append("\"");
            result.append(" throws=\"");
            Iterator<? extends Class_info> i = element.getExceptions().iterator();
            while (i.hasNext()) {
                result.append(i.next());
                if (!i.hasNext()) continue;
                result.append(", ");
            }
            result.append("\"");
        }
        return result.toString();
    }

    public int compareTo(Object other) {
        if (!(other instanceof ClassReport)) {
            throw new ClassCastException("Unable to compare ClassReport to " + other.getClass().getName());
        }
        int result = this.differences.compareTo(((ClassReport)other).differences);
        return result;
    }

    private String escapeXMLCharactersInTagContent(String text) {
        String result = text;
        result = perl.substitute("s/&/&amp;/g", result);
        result = perl.substitute("s/</&lt;/g", result);
        result = perl.substitute("s/>/&gt;/g", result);
        return result;
    }

    private String escapeXMLCharactersInAttributeValue(String text) {
        String result = this.escapeXMLCharactersInTagContent(text);
        result = perl.substitute("s/\"/&quot;/g", result);
        result = perl.substitute("s/'/&apos;/g", result);
        return result;
    }
}

