/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.Deprecatable;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.diff.APIDifferenceStrategy;
import com.jeantessier.diff.DifferenceStrategy;
import java.util.Map;

public class IncompatibleDifferenceStrategy
extends APIDifferenceStrategy {
    public IncompatibleDifferenceStrategy(DifferenceStrategy strategy) {
        super(strategy);
    }

    @Override
    public boolean isClassDifferent(Classfile oldClass, Classfile newClass) {
        return this.isRemoved(oldClass, newClass) || !this.isNew(oldClass, newClass) && this.isClassModified(oldClass, newClass);
    }

    @Override
    public boolean isFieldDifferent(Field_info oldField, Field_info newField) {
        return this.isRemoved(oldField, newField) || this.isDeprecationModified(oldField, newField) || this.isDeclarationModified(oldField, newField);
    }

    @Override
    public boolean isMethodDifferent(Method_info oldMethod, Method_info newMethod) {
        return this.isRemoved(oldMethod, newMethod) || this.isDeprecationModified(oldMethod, newMethod) || this.isDeclarationModified(oldMethod, newMethod);
    }

    @Override
    public boolean isPackageDifferent(Map<String, Classfile> oldPackage, Map<String, Classfile> newPackage) {
        return this.isPackageRemoved(oldPackage, newPackage) || !this.isPackageNew(oldPackage, newPackage) && this.isPackageModified(oldPackage, newPackage);
    }

    @Override
    public boolean isDeclarationModified(Classfile oldClass, Classfile newClass) {
        return oldClass != null && newClass != null && (oldClass.isPublic() && !newClass.isPublic() || oldClass.isInterface() != newClass.isInterface() || !oldClass.isAbstract() && newClass.isAbstract() || !oldClass.isFinal() && newClass.isFinal() || this.isExtendsClauseModified(oldClass, newClass) || this.isImplementsClauseModified(oldClass, newClass));
    }

    private boolean isExtendsClauseModified(Classfile oldClass, Classfile newClass) {
        return !oldClass.getSuperclassName().equals(newClass.getSuperclassName());
    }

    private boolean isImplementsClauseModified(Classfile oldClass, Classfile newClass) {
        return !oldClass.getAllInterfaces().containsAll(newClass.getAllInterfaces()) || !newClass.getAllInterfaces().containsAll(oldClass.getAllInterfaces());
    }

    private boolean isDeclarationModified(Field_info oldField, Field_info newField) {
        return oldField != null && newField != null && (oldField.isPublic() && !newField.isPublic() || oldField.isProtected() && (newField.isPackage() || newField.isPrivate()) || !oldField.isFinal() && newField.isFinal() || !oldField.getType().equals(newField.getType()));
    }

    private boolean isDeclarationModified(Method_info oldMethod, Method_info newMethod) {
        return oldMethod != null && newMethod != null && (oldMethod.isPublic() && !newMethod.isPublic() || oldMethod.isProtected() && (newMethod.isPackage() || newMethod.isPrivate()) || !oldMethod.isAbstract() && newMethod.isAbstract() || !oldMethod.isStatic() && newMethod.isStatic() || !oldMethod.isFinal() && newMethod.isFinal() || !oldMethod.getReturnType().equals(newMethod.getReturnType()) || this.isThrowsClauseModified(oldMethod, newMethod));
    }

    private boolean isThrowsClauseModified(Method_info oldMethod, Method_info newMethod) {
        return !oldMethod.getExceptions().containsAll(newMethod.getExceptions()) || !newMethod.getExceptions().containsAll(oldMethod.getExceptions());
    }

    @Override
    protected boolean isDeprecationModified(Deprecatable oldItem, Deprecatable newItem) {
        return oldItem != null && newItem != null && !oldItem.isDeprecated() && newItem.isDeprecated();
    }
}

