/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.BasicMeasurements;
import com.jeantessier.metrics.Measurement;
import com.jeantessier.metrics.NullMeasurement;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class Metrics {
    private static final Measurement NULL_MEASUREMENT = new NullMeasurement();
    private Metrics parent;
    private String name;
    private Map<String, Measurement> measurements = new TreeMap<String, Measurement>();
    private Map<String, Metrics> submetrics = new TreeMap<String, Metrics>();

    public Metrics(String name) {
        this(null, name);
    }

    public Metrics(Metrics parent, String name) {
        this.parent = parent;
        this.name = name;
        if (parent == null) {
            Logger.getLogger(this.getClass()).debug((Object)("Created top-level metrics \"" + name + "\""));
        } else {
            Logger.getLogger(this.getClass()).debug((Object)("Created metrics \"" + name + "\" under \"" + parent.getName() + "\""));
        }
    }

    public Metrics getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    void track(Measurement measurement) {
        this.track(measurement.getShortName(), measurement);
    }

    void track(String name, Measurement measurement) {
        this.measurements.put(name, measurement);
    }

    public void addToMeasurement(BasicMeasurements name) {
        this.addToMeasurement(name.getAbbreviation());
    }

    public void addToMeasurement(String name) {
        this.addToMeasurement(name, 1);
    }

    public void addToMeasurement(BasicMeasurements name, int delta) {
        this.addToMeasurement(name.getAbbreviation(), delta);
    }

    public void addToMeasurement(String name, int delta) {
        this.getMeasurement(name).add(delta);
    }

    public void addToMeasurement(BasicMeasurements name, long delta) {
        this.addToMeasurement(name.getAbbreviation(), delta);
    }

    public void addToMeasurement(String name, long delta) {
        this.getMeasurement(name).add(delta);
    }

    public void addToMeasurement(BasicMeasurements name, float delta) {
        this.addToMeasurement(name.getAbbreviation(), delta);
    }

    public void addToMeasurement(String name, float delta) {
        this.getMeasurement(name).add(Float.valueOf(delta));
    }

    public void addToMeasurement(BasicMeasurements name, double delta) {
        this.addToMeasurement(name.getAbbreviation(), delta);
    }

    public void addToMeasurement(String name, double delta) {
        this.getMeasurement(name).add(delta);
    }

    public void addToMeasurement(BasicMeasurements name, Object delta) {
        this.addToMeasurement(name.getAbbreviation(), delta);
    }

    public void addToMeasurement(String name, Object delta) {
        this.getMeasurement(name).add(delta);
    }

    public Measurement getMeasurement(BasicMeasurements name) {
        return this.getMeasurement(name.getAbbreviation());
    }

    public Measurement getMeasurement(String name) {
        Measurement result = this.measurements.get(name);
        if (result == null) {
            result = NULL_MEASUREMENT;
            Logger.getLogger(this.getClass()).info((Object)("Null measurement \"" + name + "\" on \"" + this.getName() + "\""));
        }
        return result;
    }

    public boolean hasMeasurement(String name) {
        return this.measurements.get(name) != null;
    }

    public Collection<String> getMeasurementNames() {
        return Collections.unmodifiableCollection(this.measurements.keySet());
    }

    public Metrics addSubMetrics(Metrics metrics) {
        return this.submetrics.put(metrics.getName(), metrics);
    }

    public Collection<Metrics> getSubMetrics() {
        return Collections.unmodifiableCollection(this.submetrics.values());
    }

    public boolean isEmpty() {
        boolean result = true;
        Iterator<Measurement> i = this.measurements.values().iterator();
        while (result && i.hasNext()) {
            Measurement measurement = i.next();
            if (!measurement.getDescriptor().isVisible()) continue;
            result = measurement.isEmpty();
        }
        Iterator<Metrics> j = this.submetrics.values().iterator();
        while (result && j.hasNext()) {
            result = j.next().isEmpty();
        }
        return result;
    }

    public boolean isInRange() {
        boolean result = true;
        Iterator<Measurement> i = this.measurements.values().iterator();
        while (result && i.hasNext()) {
            result = i.next().isInRange();
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName()).append(" ").append(this.getName()).append(" with [");
        Iterator<String> i = this.getMeasurementNames().iterator();
        while (i.hasNext()) {
            String name = i.next();
            Measurement measure = this.getMeasurement(name);
            result.append("\"").append(name).append("\"(").append(measure.getClass().getName()).append(")");
            if (!i.hasNext()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }
}

