/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.MetricsConfiguration;
import com.jeantessier.metrics.MetricsConfigurationHandler;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MetricsConfigurationLoader {
    private static final boolean DEFAULT_VALIDATE = false;
    private MetricsConfigurationHandler handler;
    private boolean validate;

    public MetricsConfigurationLoader() {
        this(new MetricsConfiguration(), false);
    }

    public MetricsConfigurationLoader(MetricsConfiguration configuration) {
        this(configuration, false);
    }

    public MetricsConfigurationLoader(boolean validate) {
        this(new MetricsConfiguration(), validate);
    }

    public MetricsConfigurationLoader(MetricsConfiguration configuration, boolean validate) {
        this.handler = new MetricsConfigurationHandler(configuration);
        this.validate = validate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsConfiguration load(String filename) throws IOException, SAXException, ParserConfigurationException {
        MetricsConfiguration result = null;
        FileReader in = null;
        try {
            in = new FileReader(filename);
            result = this.load(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return result;
    }

    public MetricsConfiguration load(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        return this.load(new InputSource(in));
    }

    public MetricsConfiguration load(Reader in) throws IOException, SAXException, ParserConfigurationException {
        return this.load(new InputSource(in));
    }

    public MetricsConfiguration load(InputSource in) throws IOException, SAXException, ParserConfigurationException {
        XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        reader.setDTDHandler(this.handler);
        reader.setContentHandler(this.handler);
        reader.setErrorHandler(this.handler);
        try {
            if (this.validate) {
                Logger.getLogger(this.getClass()).warn((Object)"XML validation turned on");
                reader.setFeature("http://xml.org/sax/features/validation", true);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
            } else {
                Logger.getLogger(this.getClass()).info((Object)"XML validation turned off");
                reader.setFeature("http://xml.org/sax/features/validation", false);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass()).warn((Object)"Problem setting validation feature on XML reader", (Throwable)ex);
        }
        reader.parse(in);
        return this.handler.getMetricsConfiguration();
    }
}

