/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import com.jeantessier.metrics.BasicMeasurements;
import com.jeantessier.metrics.MeasurementDescriptor;
import com.jeantessier.metrics.Metrics;
import com.jeantessier.metrics.MetricsConfiguration;
import com.jeantessier.metrics.WordCounter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public class MetricsFactory {
    private static final Perl5Util perl = new Perl5Util();
    private String projectName;
    private MetricsConfiguration configuration;
    private Map<String, Metrics> projects = new HashMap<String, Metrics>();
    private Map<String, Metrics> groups = new HashMap<String, Metrics>();
    private Map<String, Metrics> classes = new HashMap<String, Metrics>();
    private Map<String, Metrics> methods = new HashMap<String, Metrics>();
    private Map<String, Metrics> includedProjects = new HashMap<String, Metrics>();
    private Map<String, Metrics> includedGroups = new HashMap<String, Metrics>();
    private Map<String, Metrics> includedClasses = new HashMap<String, Metrics>();
    private Map<String, Metrics> includedMethods = new HashMap<String, Metrics>();
    private WordCounter counter = new WordCounter();

    public MetricsFactory(String projectName, MetricsConfiguration configuration) {
        this.projectName = projectName;
        this.configuration = configuration;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public MetricsConfiguration getConfiguration() {
        return this.configuration;
    }

    public Metrics createProjectMetrics() {
        return this.createProjectMetrics(this.getProjectName());
    }

    public Metrics createProjectMetrics(String name) {
        Metrics result = this.projects.get(name);
        if (result == null) {
            result = this.buildProjectMetrics(name);
            this.projects.put(name, result);
        }
        return result;
    }

    private Metrics buildProjectMetrics(String name) {
        Metrics result = new Metrics(name);
        this.populateMetrics(result, this.getConfiguration().getProjectMeasurements());
        return result;
    }

    public void includeProjectMetrics(Metrics metrics) {
        this.includedProjects.put(metrics.getName(), metrics);
    }

    public Collection<String> getProjectNames() {
        return Collections.unmodifiableCollection(this.includedProjects.keySet());
    }

    public Collection<Metrics> getProjectMetrics() {
        return Collections.unmodifiableCollection(this.includedProjects.values());
    }

    public Collection<String> getAllProjectNames() {
        return Collections.unmodifiableCollection(this.projects.keySet());
    }

    public Collection<Metrics> getAllProjectMetrics() {
        return Collections.unmodifiableCollection(this.projects.values());
    }

    public Metrics createGroupMetrics(String name) {
        Metrics result = this.groups.get(name);
        if (result == null) {
            result = this.buildGroupMetrics(name);
            this.groups.put(name, result);
        }
        return result;
    }

    private Metrics buildGroupMetrics(String name) {
        Metrics projectMetrics = this.createProjectMetrics();
        Metrics result = new Metrics(projectMetrics, name);
        this.populateMetrics(result, this.getConfiguration().getGroupMeasurements());
        this.initializeGroupMetrics(name, result);
        return result;
    }

    private void initializeGroupMetrics(String packageName, Metrics metrics) {
        this.computePackageNameCharacterCount(packageName, metrics);
        this.computePackageNameWordCount(packageName, metrics);
    }

    private void computePackageNameCharacterCount(String packageName, Metrics metrics) {
        metrics.addToMeasurement(BasicMeasurements.GROUP_NAME_CHARACTER_COUNT, packageName.length());
    }

    private void computePackageNameWordCount(String packageName, Metrics metrics) {
        metrics.addToMeasurement(BasicMeasurements.GROUP_NAME_WORD_COUNT, this.counter.countPackageName(packageName));
    }

    public void includeGroupMetrics(Metrics metrics) {
        this.includedGroups.put(metrics.getName(), metrics);
        metrics.getParent().addSubMetrics(metrics);
        this.includeProjectMetrics(metrics.getParent());
    }

    public Collection<String> getGroupNames() {
        return Collections.unmodifiableCollection(this.includedGroups.keySet());
    }

    public Collection<Metrics> getGroupMetrics() {
        return Collections.unmodifiableCollection(this.includedGroups.values());
    }

    public Collection<String> getAllGroupNames() {
        return Collections.unmodifiableCollection(this.groups.keySet());
    }

    public Collection<Metrics> getAllGroupMetrics() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Metrics createClassMetrics(String name) {
        Metrics result = this.classes.get(name);
        if (result == null) {
            result = this.buildClassMetrics(name);
            this.classes.put(name, result);
        }
        return result;
    }

    private Metrics buildClassMetrics(String name) {
        String packageName = "";
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            packageName = name.substring(0, pos);
        }
        String className = name.substring(pos + 1);
        Metrics packageMetrics = this.createGroupMetrics(packageName);
        Metrics result = new Metrics(packageMetrics, name);
        this.populateMetrics(result, this.getConfiguration().getClassMeasurements());
        this.initializeClassMetrics(className, result);
        return result;
    }

    private void initializeClassMetrics(String className, Metrics metrics) {
        this.computeClassNameCharacterCount(className, metrics);
        this.computeClassNameWordCount(className, metrics);
    }

    private void computeClassNameCharacterCount(String className, Metrics metrics) {
        metrics.addToMeasurement(BasicMeasurements.CLASS_NAME_CHARACTER_COUNT, className.length());
    }

    private void computeClassNameWordCount(String className, Metrics metrics) {
        metrics.addToMeasurement(BasicMeasurements.CLASS_NAME_WORD_COUNT, this.counter.countIdentifier(className));
    }

    public void includeClassMetrics(Metrics metrics) {
        this.includedClasses.put(metrics.getName(), metrics);
        metrics.getParent().addSubMetrics(metrics);
        this.includeGroupMetrics(metrics.getParent());
        for (String name : this.getConfiguration().getGroups(metrics.getName())) {
            Metrics groupMetrics = this.createGroupMetrics(name);
            groupMetrics.addSubMetrics(metrics);
            this.includeGroupMetrics(groupMetrics);
        }
    }

    public Collection<String> getClassNames() {
        return Collections.unmodifiableCollection(this.includedClasses.keySet());
    }

    public Collection<Metrics> getClassMetrics() {
        return Collections.unmodifiableCollection(this.includedClasses.values());
    }

    public Collection<String> getAllClassNames() {
        return Collections.unmodifiableCollection(this.classes.keySet());
    }

    public Collection<Metrics> getAllClassMetrics() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public Metrics createMethodMetrics(String name) {
        Metrics result = this.methods.get(name);
        if (result == null) {
            result = this.buildMethodMetrics(name);
            this.methods.put(name, result);
        }
        return result;
    }

    private Metrics buildMethodMetrics(String name) {
        String className = "";
        String featureName = "";
        if (perl.match("/^(.*)\\.([^\\.]*)\\(.*\\)$/", name)) {
            className = perl.group(1);
            featureName = perl.group(2);
        } else if (perl.match("/^(.*)\\.(static) {}$/", name)) {
            className = perl.group(1);
            featureName = perl.group(2);
        } else if (perl.match("/^(.*)\\.([\\^.]*)$/", name)) {
            className = perl.group(1);
            featureName = perl.group(2);
        }
        Metrics classMetrics = this.createClassMetrics(className);
        Metrics result = new Metrics(classMetrics, name);
        classMetrics.addSubMetrics(result);
        this.populateMetrics(result, this.getConfiguration().getMethodMeasurements());
        this.initializeMethodMetrics(featureName, result);
        return result;
    }

    private void initializeMethodMetrics(String featureName, Metrics metrics) {
        this.computeMethodNameCharacterCount(featureName, metrics);
        this.computeMethodNameWordCount(featureName, metrics);
    }

    private void computeMethodNameCharacterCount(String featureName, Metrics metrics) {
        metrics.addToMeasurement(BasicMeasurements.METHOD_NAME_CHARACTER_COUNT, featureName.length());
    }

    private void computeMethodNameWordCount(String featureName, Metrics metrics) {
        metrics.addToMeasurement(BasicMeasurements.METHOD_NAME_WORD_COUNT, this.counter.countIdentifier(featureName));
    }

    public void includeMethodMetrics(Metrics metrics) {
        this.includedMethods.put(metrics.getName(), metrics);
        metrics.getParent().addSubMetrics(metrics);
        this.includeClassMetrics(metrics.getParent());
    }

    public Collection<String> getMethodNames() {
        return Collections.unmodifiableCollection(this.includedMethods.keySet());
    }

    public Collection<Metrics> getMethodMetrics() {
        return Collections.unmodifiableCollection(this.includedMethods.values());
    }

    public Collection<String> getAllMethodNames() {
        return Collections.unmodifiableCollection(this.methods.keySet());
    }

    public Collection<Metrics> getAllMethodMetrics() {
        return Collections.unmodifiableCollection(this.methods.values());
    }

    public void clear() {
        this.projects.clear();
        this.groups.clear();
        this.classes.clear();
        this.methods.clear();
        this.includedProjects.clear();
        this.includedGroups.clear();
        this.includedClasses.clear();
        this.includedMethods.clear();
    }

    private void populateMetrics(Metrics metrics, Collection<MeasurementDescriptor> descriptors) {
        for (MeasurementDescriptor descriptor : descriptors) {
            try {
                metrics.track(descriptor.createMeasurement(metrics));
            }
            catch (InstantiationException ex) {
                Logger.getLogger(this.getClass()).warn((Object)("Unable to create measurement \"" + descriptor.getShortName() + "\""), (Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(this.getClass()).warn((Object)("Unable to create measurement \"" + descriptor.getShortName() + "\""), (Throwable)ex);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(this.getClass()).warn((Object)("Unable to create measurement \"" + descriptor.getShortName() + "\""), (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(this.getClass()).warn((Object)("Unable to create measurement \"" + descriptor.getShortName() + "\""), (Throwable)ex);
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Factory for project \"").append(this.getProjectName()).append("\"").append(System.getProperty("line.separator", "\n"));
        result.append("projects:").append(System.getProperty("line.separator", "\n"));
        for (Map.Entry<String, Metrics> entry : this.projects.entrySet()) {
            result.append("    ").append(entry.getKey()).append(" -> ").append(entry.getValue().getName()).append("").append(System.getProperty("line.separator", "\n"));
        }
        result.append("groups:").append(System.getProperty("line.separator", "\n"));
        for (Map.Entry<String, Metrics> entry : this.groups.entrySet()) {
            result.append("    ").append(entry.getKey()).append(" -> ").append(entry.getValue().getName()).append("").append(System.getProperty("line.separator", "\n"));
        }
        result.append("classes:").append(System.getProperty("line.separator", "\n"));
        for (Map.Entry<String, Metrics> entry : this.classes.entrySet()) {
            result.append("    ").append(entry.getKey()).append(" -> ").append(entry.getValue().getName()).append("").append(System.getProperty("line.separator", "\n"));
        }
        result.append("methods:").append(System.getProperty("line.separator", "\n"));
        for (Map.Entry<String, Metrics> entry : this.methods.entrySet()) {
            result.append("    ").append(entry.getKey()).append(" -> ").append(entry.getValue().getName()).append("").append(System.getProperty("line.separator", "\n"));
        }
        return result.toString();
    }
}

