/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.math.Matrix4f;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import projectkyoto.jme3.mmd.SkeletonControl;
import projectkyoto.mmd.file.PMDBone;

public class PMDBoneMarkControl
extends AbstractControl {
    SkeletonControl skeletonControl;
    Spatial[] boneMarkArray;
    PMDBone[] boneArray;
    Camera cam;

    public PMDBoneMarkControl(SkeletonControl skeletonControl, Spatial[] boneMarkArray, PMDBone[] boneArray) {
        this.skeletonControl = skeletonControl;
        this.boneMarkArray = boneMarkArray;
        this.boneArray = boneArray;
    }

    protected void controlUpdate(float tpf) {
        for (int i = 0; i < this.boneMarkArray.length; ++i) {
            Matrix4f m = this.skeletonControl.getOffsetMatrices()[i].clone();
            PMDBone bone = this.boneArray[i];
            Vector3f bonePos = new Vector3f(bone.getBoneHeadPos().x, bone.getBoneHeadPos().y, bone.getBoneHeadPos().z);
            m.mult(bonePos, bonePos);
            Transform t = new Transform(m.toTranslationVector());
            this.cam.getScreenCoordinates(bonePos, bonePos);
            t.setTranslation(bonePos);
            this.boneMarkArray[i].setLocalTransform(t);
        }
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public Control cloneForSpatial(Spatial spatial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Camera getCam() {
        return this.cam;
    }

    public void setCam(Camera cam) {
        this.cam = cam;
    }
}

