/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.jme3.mmd;

import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingVolume;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix4f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class PMDMesh
extends Mesh {
    int[] boneIndexArray;
    Matrix4f[] boneMatrixArray;
    VertexBuffer vbBackup;
    VertexBuffer nbBackup;
    ShortBuffer boneIndexBuffer;
    FloatBuffer boneMatrixBuffer;
    int boneMatricesParamIndex = -1;
    BoundingVolume bound = new BoundingBox(Vector3f.ZERO, 20.0f, 20.0f, 20.0f);

    public int[] getBoneIndexArray() {
        return this.boneIndexArray;
    }

    public void setBoneIndexArray(int[] boneIndexArray) {
        this.boneIndexArray = boneIndexArray;
    }

    public Matrix4f[] getBoneMatrixArray() {
        return this.boneMatrixArray;
    }

    public void setBoneMatrixArray(Matrix4f[] boneMatrixArray) {
        this.boneMatrixArray = boneMatrixArray;
    }

    public BoundingVolume getBound() {
        return this.bound;
    }

    public synchronized PMDMesh clone() {
        PMDMesh newMesh = (PMDMesh)super.clone();
        this.boneMatricesParamIndex = -1;
        newMesh.boneMatrixArray = new Matrix4f[this.boneMatrixArray.length];
        for (int i = 0; i < newMesh.boneMatrixArray.length; ++i) {
            newMesh.boneMatrixArray[i] = new Matrix4f();
        }
        newMesh.setBuffer(this.getBuffer(VertexBuffer.Type.BoneIndex));
        newMesh.setBuffer(this.getBuffer(VertexBuffer.Type.TexCoord));
        this.releaseSoftwareSkinningBufferes();
        FloatBuffer newBoneMatrixBuffer = BufferUtils.createFloatBuffer((int)this.boneMatrixBuffer.capacity());
        this.boneMatrixBuffer.position(0);
        newBoneMatrixBuffer.put(this.boneMatrixBuffer);
        newBoneMatrixBuffer.position(0);
        newMesh.setBoneMatrixBuffer(newBoneMatrixBuffer);
        return newMesh;
    }

    public VertexBuffer getNbBackup() {
        return this.nbBackup;
    }

    public void setNbBackup(VertexBuffer nbBackup) {
        this.nbBackup = nbBackup;
    }

    public VertexBuffer getVbBackup() {
        return this.vbBackup;
    }

    public void setVbBackup(VertexBuffer vbBackup) {
        this.vbBackup = vbBackup;
    }

    public void createSoftwareSkinningBuffers() {
        boolean retryFlag = false;
        while (true) {
            try {
                VertexBuffer vb = new VertexBuffer(VertexBuffer.Type.Position);
                FloatBuffer vfb = BufferUtils.clone((FloatBuffer)((FloatBuffer)this.vbBackup.getData()));
                vb.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, (Buffer)vfb);
                this.clearBuffer(VertexBuffer.Type.Position);
                this.setBuffer(vb);
            }
            catch (OutOfMemoryError ex) {
                if (!retryFlag) {
                    System.gc();
                    retryFlag = true;
                    continue;
                }
                throw new RuntimeException(ex);
            }
            break;
        }
        retryFlag = false;
        while (true) {
            try {
                VertexBuffer nb = new VertexBuffer(VertexBuffer.Type.Normal);
                FloatBuffer nfb = BufferUtils.clone((FloatBuffer)((FloatBuffer)this.nbBackup.getData()));
                nb.setupData(VertexBuffer.Usage.Dynamic, 3, VertexBuffer.Format.Float, (Buffer)nfb);
                this.clearBuffer(VertexBuffer.Type.Normal);
                this.setBuffer(nb);
            }
            catch (OutOfMemoryError ex) {
                if (!retryFlag) {
                    System.gc();
                    retryFlag = true;
                    continue;
                }
                throw new RuntimeException(ex);
            }
            break;
        }
    }

    public void releaseSoftwareSkinningBufferes() {
        this.clearBuffer(VertexBuffer.Type.Position);
        this.setBuffer(this.vbBackup);
        this.clearBuffer(VertexBuffer.Type.Normal);
        this.setBuffer(this.nbBackup);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule c = im.getCapsule((Savable)this);
        this.boneIndexArray = c.readIntArray("boneIndexArray", null);
        this.boneMatrixArray = new Matrix4f[this.boneIndexArray.length];
        for (int i = 0; i < this.boneMatrixArray.length; ++i) {
            this.boneMatrixArray[i] = new Matrix4f();
            this.boneMatrixArray[i].loadIdentity();
        }
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule c = ex.getCapsule((Savable)this);
        c.write(this.boneIndexArray, "boneIndexArray", null);
    }

    public ShortBuffer getBoneIndexBuffer() {
        return this.boneIndexBuffer;
    }

    public void setBoneIndexBuffer(ShortBuffer boneIndexBuffer) {
        this.boneIndexBuffer = boneIndexBuffer;
    }

    public FloatBuffer getBoneMatrixBuffer() {
        return this.boneMatrixBuffer;
    }

    public void setBoneMatrixBuffer(FloatBuffer boneMatrixBuffer) {
        this.boneMatrixBuffer = boneMatrixBuffer;
    }
}

