/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import projectkyoto.mmd.file.DataInputStreamLittleEndian;
import projectkyoto.mmd.file.PMDUtil;
import projectkyoto.mmd.file.XMaterial;

public class PMDMaterial
implements Serializable {
    private XMaterial material;
    private byte toonIndex;
    private byte edgeFlag;
    private int faceVertCount;
    private String textureFileName;
    private int materialNo;

    public PMDMaterial() {
    }

    public PMDMaterial(DataInputStreamLittleEndian is) throws IOException {
        this.material = new XMaterial(is);
        this.toonIndex = is.readByte();
        this.edgeFlag = is.readByte();
        this.faceVertCount = is.readInt();
        this.textureFileName = is.readString(20);
    }

    public void writeToStream(DataOutput os) throws IOException {
        this.material.writeToStream(os);
        os.writeByte(this.toonIndex);
        os.writeByte(this.edgeFlag);
        os.writeInt(this.faceVertCount);
        PMDUtil.writeString(os, this.textureFileName, 20);
    }

    public byte getEdgeFlag() {
        return this.edgeFlag;
    }

    public void setEdgeFlag(byte edgeFlag) {
        this.edgeFlag = edgeFlag;
    }

    public int getFaceVertCount() {
        return this.faceVertCount;
    }

    public void setFaceVertCount(int faceVertCount) {
        this.faceVertCount = faceVertCount;
    }

    public XMaterial getMaterial() {
        return this.material;
    }

    public void setMaterial(XMaterial material) {
        this.material = material;
    }

    public String getTextureFileName() {
        return this.textureFileName;
    }

    public void setTextureFileName(String textureFileName) {
        this.textureFileName = textureFileName;
    }

    public byte getToonIndex() {
        return this.toonIndex;
    }

    public void setToonIndex(byte toonIndex) {
        this.toonIndex = toonIndex;
    }

    public int getMaterialNo() {
        return this.materialNo;
    }

    public void setMaterialNo(int materialNo) {
        this.materialNo = materialNo;
    }

    public String toString() {
        return "{material = " + this.material + " toonIndex = " + this.toonIndex + " edgeFlag = " + this.edgeFlag + " faceVertCount = " + this.faceVertCount + " textureFileName = " + this.textureFileName + "}\n";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PMDMaterial other = (PMDMaterial)obj;
        if (!(this.material == other.material || this.material != null && this.material.equals(other.material))) {
            return false;
        }
        if (this.toonIndex != other.toonIndex) {
            return false;
        }
        if (this.edgeFlag != other.edgeFlag) {
            return false;
        }
        return !(this.textureFileName == null ? other.textureFileName != null : !this.textureFileName.equals(other.textureFileName));
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.material != null ? this.material.hashCode() : 0);
        return hash;
    }
}

