/*
 * Decompiled with CFR 0.152.
 */
package projectkyoto.mmd.file.util2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import projectkyoto.mmd.file.PMDMaterial;
import projectkyoto.mmd.file.PMDModel;
import projectkyoto.mmd.file.PMDSkinData;
import projectkyoto.mmd.file.PMDVertex;
import projectkyoto.mmd.file.pmn.PMNData;
import projectkyoto.mmd.file.pmn.PMNMesh;
import projectkyoto.mmd.file.pmn.PMNSkinMesh;
import projectkyoto.mmd.file.util2.MeshData;
import projectkyoto.mmd.file.util2.SkinMeshData;
import projectkyoto.mmd.file.util2.VertIndex;

public class MeshConverter
implements Serializable {
    PMDModel model;
    public static int DEFAULT_MAX_BONE_SIZE = 20;
    int maxBoneSize = DEFAULT_MAX_BONE_SIZE;
    List<MeshData> meshDataList = new ArrayList<MeshData>();
    SkinMeshData skinMeshData;
    HashMap<Integer, Integer> meshTmpVertMap = new HashMap();
    HashMap<Integer, Integer> skinTmpVertMap = new HashMap();
    public ByteBuffer interleavedBuffer;
    int currentVertIndex = 0;
    PMNData pmnData;
    VertIndex tmpvi = new VertIndex(0);
    Set<VertIndex> skinVertSet = new HashSet<VertIndex>();

    public MeshConverter() {
    }

    public MeshConverter(PMDModel model) {
        this.model = model;
        this.skinMeshData = new SkinMeshData(this, model);
        this.initSkinVertSet();
    }

    private final void initSkinVertSet() {
        for (int skinCount = 0; skinCount < this.model.getSkinCount(); ++skinCount) {
            PMDSkinData skinData = this.model.getSkinData()[skinCount];
            if (skinData.getSkinType() != 0) continue;
            for (int skinVertCount = 0; skinVertCount < skinData.getSkinVertCount(); ++skinVertCount) {
                VertIndex vi = new VertIndex(skinData.getIndexBuf().get(skinVertCount));
                this.skinVertSet.add(vi);
            }
            break;
        }
    }

    public void checkDupMaterial() {
        for (int i1 = 0; i1 < this.model.getMaterialCount(); ++i1) {
            for (int i2 = i1 + 1; i2 < this.model.getMaterialCount() && !this.model.getMaterial()[i1].equals(this.model.getMaterial()[i2]); ++i2) {
            }
        }
    }

    void printFaceVertSize() {
        for (int skinCount = 0; skinCount < this.model.getSkinCount(); ++skinCount) {
            PMDSkinData pMDSkinData = this.model.getSkinData()[skinCount];
        }
    }

    public void convertMesh() {
        int faceVertNo = 0;
        for (int materialNo = 0; materialNo < this.model.getMaterialCount(); ++materialNo) {
            this.meshTmpVertMap.clear();
            PMDMaterial material = this.model.getMaterial()[materialNo];
            MeshData meshData = new MeshData(this.model, this.maxBoneSize, material);
            for (int meshIndex = this.meshDataList.size() - 1; meshIndex >= 0; --meshIndex) {
                PMDMaterial material2 = this.meshDataList.get(meshIndex).getMaterial();
                if (!material.equals(material2)) continue;
                meshData = this.meshDataList.get(meshIndex);
                for (int i = meshData.getVertIndexList().size() - 1; i >= 0; --i) {
                    Integer vertIndex = meshData.getVertIndexList().get(i);
                    this.meshTmpVertMap.put(vertIndex, i);
                }
                break;
            }
            if (material.getFaceVertCount() == 0) continue;
            if (!this.meshDataList.contains(meshData)) {
                this.meshDataList.add(meshData);
            }
            for (int materialFaceVertNo = 0; materialFaceVertNo < material.getFaceVertCount(); materialFaceVertNo += 3) {
                int i3;
                int i1 = this.model.getFaceVertIndex()[faceVertNo++];
                int i2 = this.model.getFaceVertIndex()[faceVertNo++];
                if (this.containsSkin(i1, i2, i3 = this.model.getFaceVertIndex()[faceVertNo++])) {
                    this.addSkinTriangle(material, i1, i2, i3);
                    continue;
                }
                if (meshData.addTriangle(this, i1, i2, i3)) continue;
                meshData = new MeshData(this.model, this.maxBoneSize, material);
                this.meshTmpVertMap.clear();
                this.meshDataList.add(meshData);
                meshData.addTriangle(this, i1, i2, i3);
            }
            if (meshData.material.getFaceVertCount() != 0) continue;
            this.meshDataList.remove(this.meshDataList.size() - 1);
        }
        this.skinTmpVertMap = null;
        Iterator<MeshData> it = this.meshDataList.iterator();
        while (it.hasNext()) {
            MeshData md = it.next();
            if (md.getIndexList().size() == 0) {
                it.remove();
                continue;
            }
            md.createMesh();
        }
        this.skinMeshData.createSkinCommonVertData();
        this.meshTmpVertMap = null;
        this.skinTmpVertMap = null;
    }

    void removeUnusedSkinVertex() {
        HashSet tmpSet = new HashSet();
        PMDSkinData skinData0 = null;
        for (PMDSkinData skinData : this.model.getSkinData()) {
            if (skinData.getSkinType() != 0) continue;
            skinData0 = skinData;
        }
        Iterator<VertIndex> it = this.skinVertSet.iterator();
        while (it.hasNext()) {
            VertIndex vi = it.next();
            if (tmpSet.contains(vi.index)) continue;
            it.remove();
        }
    }

    void printMeshData(MeshData meshData) {
    }

    boolean containsSkin(int i1, int i2, int i3) {
        return this.containsSkin(i1) || this.containsSkin(i2) || this.containsSkin(i3);
    }

    boolean containsSkin(int i) {
        this.tmpvi.index = i;
        return this.skinVertSet.contains(this.tmpvi);
    }

    void addSkinTriangle(PMDMaterial material, int i1, int i2, int i3) {
        this.skinMeshData.addTriangle(this, material, i1, i2, i3);
    }

    public PMNData createPMNData() {
        this.pmnData = new PMNData();
        PMNMesh[] meshArrah = new PMNMesh[this.meshDataList.size()];
        for (int i = 0; i < this.meshDataList.size(); ++i) {
            MeshData md = this.meshDataList.get(i);
            PMNMesh pmnMesh = new PMNMesh();
            this.createInterleavedBuffer(md, pmnMesh);
        }
        PMNSkinMesh pmnSkinMesh = new PMNSkinMesh();
        ByteBuffer pointBuffer = ByteBuffer.allocateDirect(12 * this.skinMeshData.vertexList.size());
        pointBuffer.order(ByteOrder.nativeOrder());
        pmnSkinMesh.setPointBuffer(pointBuffer.asFloatBuffer());
        ByteBuffer normalBuffer = ByteBuffer.allocateDirect(12 * this.skinMeshData.vertexList.size());
        normalBuffer.order(ByteOrder.nativeOrder());
        pmnSkinMesh.setNormalBuffer(normalBuffer.asFloatBuffer());
        ByteBuffer texCoordBuffer = ByteBuffer.allocateDirect(8 * this.skinMeshData.vertexList.size());
        texCoordBuffer.order(ByteOrder.nativeOrder());
        pmnSkinMesh.setTexCoordBuffer(texCoordBuffer.asFloatBuffer());
        ByteBuffer boneIndexBuffer = ByteBuffer.allocateDirect(4 * this.skinMeshData.vertexList.size());
        boneIndexBuffer.order(ByteOrder.nativeOrder());
        pmnSkinMesh.setBoneIndexBuffer(boneIndexBuffer.asShortBuffer());
        ByteBuffer boneWeightBuffer = ByteBuffer.allocateDirect(8 * this.skinMeshData.vertexList.size());
        boneWeightBuffer.order(ByteOrder.nativeOrder());
        pmnSkinMesh.setBoneWeightBuffer(boneWeightBuffer.asFloatBuffer());
        for (PMDVertex v : this.skinMeshData.vertexList) {
            pointBuffer.putFloat(v.getPos().x).putFloat(v.getPos().y).putFloat(v.getPos().z);
            normalBuffer.putFloat(v.getNormal().x).putFloat(v.getNormal().y).putFloat(v.getNormal().z);
            texCoordBuffer.putFloat(v.getUv().getU()).putFloat(v.getUv().getV());
            short boneIndex = (short)this.skinMeshData.boneList.indexOf(v.getBoneNum1());
            if (boneIndex < 0) {
                boneIndex = 0;
            }
            boneIndexBuffer.putShort(boneIndex);
            boneIndex = (short)this.skinMeshData.boneList.indexOf(v.getBoneNum2());
            if (boneIndex < 0) {
                boneIndex = 0;
            }
            boneIndexBuffer.putShort(boneIndex);
            float weight = (float)v.getBoneWeight() / 100.0f;
            boneWeightBuffer.putFloat(weight).putFloat(1.0f - weight);
        }
        pmnSkinMesh.setIndexBufferArray(new ShortBuffer[this.skinMeshData.indexMap.size()]);
        pmnSkinMesh.setMaterialIndexArray(new int[this.skinMeshData.indexMap.size()]);
        int i = 0;
        for (PMDMaterial m : this.skinMeshData.indexMap.keySet()) {
            List<Integer> indexList = this.skinMeshData.indexMap.get(m);
            ByteBuffer indexBuffer = ByteBuffer.allocateDirect(2 * indexList.size());
            indexBuffer.order(ByteOrder.nativeOrder());
            for (Integer index : indexList) {
                indexBuffer.putShort(index.shortValue());
            }
            pmnSkinMesh.getIndexBufferArray()[i] = indexBuffer.asShortBuffer();
            for (int mi = 0; mi < this.model.getMaterialCount(); ++mi) {
                if (this.model.getMaterial()[mi] != m) continue;
                pmnSkinMesh.getMaterialIndexArray()[i] = mi;
                break;
            }
            ++i;
        }
        return this.pmnData;
    }

    public void createInterleavedBuffer(MeshData md, PMNMesh pmnMesh) {
        int i;
        byte offset = 0;
        byte[] offsetArray = new byte[5];
        pmnMesh.setOffsetArray(offsetArray);
        short[] boneIndexArray = new short[md.boneList.size()];
        pmnMesh.setBoneIndexArray(boneIndexArray);
        offsetArray[0] = offset;
        offsetArray[1] = offset = (byte)(offset + 12);
        offset = (byte)(offset + 12);
        if (md.material.getTextureFileName().length() >= 0) {
            offsetArray[2] = offset;
            offset = (byte)(offset + 8);
        } else {
            offsetArray[2] = -1;
        }
        offsetArray[3] = offset;
        offsetArray[4] = offset = (byte)(offset + 4);
        offset = (byte)(offset + 8);
        pmnMesh.setStride(offset);
        ByteBuffer interleavedBuffer = ByteBuffer.allocateDirect(offset * md.vertIndexList.size());
        interleavedBuffer.order(ByteOrder.nativeOrder());
        pmnMesh.setInterleavedBuffer(interleavedBuffer);
        PMDVertex v = new PMDVertex();
        for (Integer vertIndex : md.getVertIndexList()) {
            short boneIndex;
            this.model.getVertex(vertIndex, v);
            interleavedBuffer.putFloat(v.getPos().x).putFloat(v.getPos().y).putFloat(v.getPos().z);
            interleavedBuffer.putFloat(v.getNormal().x).putFloat(v.getNormal().y).putFloat(v.getNormal().z);
            if (offsetArray[2] >= 0) {
                interleavedBuffer.putFloat(v.getUv().getU()).putFloat(v.getUv().getV());
            }
            if ((boneIndex = (short)md.boneList.indexOf(v.getBoneNum1())) < 0) {
                boneIndex = 0;
            }
            interleavedBuffer.putShort(boneIndex);
            boneIndex = (short)md.boneList.indexOf(v.getBoneNum2());
            if (boneIndex < 0) {
                boneIndex = 0;
            }
            interleavedBuffer.putShort(boneIndex);
            float weight = (float)v.getBoneWeight() / 100.0f;
            interleavedBuffer.putFloat(weight).putFloat(1.0f - weight);
        }
        ByteBuffer indexBuffer = ByteBuffer.allocateDirect(2 * md.getIndexList().size());
        indexBuffer.order(ByteOrder.nativeOrder());
        for (Integer index : md.getIndexList()) {
            indexBuffer.putShort(index.shortValue());
        }
        pmnMesh.setIndexBuffer(indexBuffer.asShortBuffer());
        for (i = 0; i < this.model.getMaterialCount(); ++i) {
            if (this.model.getMaterial()[i] != md.getMaterial()) continue;
            pmnMesh.setMaterialIndex(this.model.getFaceVertCount());
            break;
        }
        for (i = 0; i < boneIndexArray.length; ++i) {
            boneIndexArray[i] = md.boneList.get(i).shortValue();
        }
    }

    public int calcPMNSize() {
        int size = 16;
        for (MeshData md : this.meshDataList) {
            int stride = md.material.getTextureFileName().length() >= 0 ? 44 : 36;
            size += stride * md.getVertIndexList().size();
            size += 2 * md.getIndexList().size();
        }
        return size;
    }

    public void write(OutputStream os) throws IOException {
        DataOutputStream dos = new DataOutputStream(os);
        byte[] buf = new byte[16384];
        dos.writeInt(this.meshDataList.size());
        for (int i = 0; i < this.meshDataList.size(); ++i) {
            MeshData md = this.meshDataList.get(i);
            md.write(dos, buf);
        }
        this.skinMeshData.write(dos, buf);
        dos.flush();
    }

    public void read(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        byte[] buf = new byte[16384];
        this.meshDataList = new ArrayList<MeshData>();
        int meshDataSize = dis.readInt();
        for (int i = 0; i < meshDataSize; ++i) {
            MeshData md = new MeshData(this.model, this.maxBoneSize, null);
            md.read(dis, buf);
            this.meshDataList.add(md);
        }
        this.skinMeshData = new SkinMeshData();
        this.skinMeshData.model = this.model;
        this.skinMeshData.read(dis, buf);
    }

    public int getMaxBoneSize() {
        return this.maxBoneSize;
    }

    public void setMaxBoneSize(int maxBoneSize) {
        this.maxBoneSize = maxBoneSize;
    }

    public List<MeshData> getMeshDataList() {
        return this.meshDataList;
    }

    public void setMeshDataList(List<MeshData> meshDataList) {
        this.meshDataList = meshDataList;
    }

    public PMDModel getModel() {
        return this.model;
    }

    public void setModel(PMDModel model) {
        this.model = model;
    }

    public SkinMeshData getSkinMeshData() {
        return this.skinMeshData;
    }

    public void setSkinMeshData(SkinMeshData skinMeshData) {
        this.skinMeshData = skinMeshData;
    }

    public PMNData getPmnData() {
        return this.pmnData;
    }
}

