/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.table;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.builder.ControlBuilder;
import de.lessvoid.nifty.builder.ControlDefinitionBuilder;
import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.HoverEffectBuilder;
import de.lessvoid.nifty.builder.LayerBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.builder.ScreenBuilder;
import de.lessvoid.nifty.builder.TextBuilder;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.listbox.builder.ListBoxBuilder;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.PanelRenderer;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.examples.LwjglInitHelper;
import de.lessvoid.nifty.renderer.lwjgl.render.LwjglRenderDevice;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.sound.openal.OpenALSoundDevice;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.sound.SoundDevice;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.TimeProvider;
import java.io.IOException;
import java.util.Random;

public class TableExampleMain {
    static final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static Random rnd = new Random();

    public static void main(String[] args) throws IOException {
        if (!LwjglInitHelper.initSubSystems("Nifty Table Example")) {
            System.exit(0);
        }
        Nifty nifty = new Nifty((RenderDevice)new LwjglRenderDevice(), (SoundDevice)new OpenALSoundDevice(), (InputSystem)LwjglInitHelper.getInputSystem(), new TimeProvider());
        nifty.loadControlFile("nifty-default-controls.xml");
        nifty.loadStyleFile("nifty-default-styles.xml");
        ControlDefinitionBuilder rowControlBuilder = new ControlDefinitionBuilder("row"){
            {
                this.panel(new PanelBuilder(){
                    {
                        this.height("30px");
                        this.childLayoutHorizontal();
                        this.width("100%");
                        this.alignCenter();
                        this.text(new TextBuilder("#col-0"){
                            {
                                this.width("20%");
                                this.height("100%");
                                this.textVAlignCenter();
                                this.style("base-font");
                            }
                        });
                        this.text(new TextBuilder("#col-1"){
                            {
                                this.width("20%");
                                this.height("100%");
                                this.textVAlignCenter();
                                this.style("base-font");
                            }
                        });
                        this.text(new TextBuilder("#col-2"){
                            {
                                this.width("20%");
                                this.height("100%");
                                this.textVAlignCenter();
                                this.style("base-font");
                            }
                        });
                        this.text(new TextBuilder("#col-3"){
                            {
                                this.width("20%");
                                this.height("100%");
                                this.textVAlignCenter();
                                this.style("base-font");
                            }
                        });
                        this.text(new TextBuilder("#col-4"){
                            {
                                this.width("20%");
                                this.height("100%");
                                this.textVAlignCenter();
                                this.style("base-font");
                            }
                        });
                        this.visibleToMouse();
                        this.controller("de.lessvoid.nifty.controls.listbox.ListBoxItemController");
                        this.inputMapping("de.lessvoid.nifty.input.mapping.MenuInputMapping");
                        this.onHoverEffect(new HoverEffectBuilder("colorBar"){
                            {
                                this.effectParameter("color", "#880f");
                                this.post(true);
                                this.inset("1px");
                                this.neverStopRendering(true);
                                this.effectParameter("timeType", "infinite");
                            }
                        });
                        this.onCustomEffect(new EffectBuilder("colorBar"){
                            {
                                this.customKey("focus");
                                this.post(false);
                                this.effectParameter("color", "#f00f");
                                this.neverStopRendering(true);
                                this.effectParameter("timeType", "infinite");
                            }
                        });
                        this.onCustomEffect(new EffectBuilder("colorBar"){
                            {
                                this.customKey("select");
                                this.post(false);
                                this.effectParameter("color", "#f00f");
                                this.neverStopRendering(true);
                                this.effectParameter("timeType", "infinite");
                            }
                        });
                        this.onCustomEffect(new EffectBuilder("textColor"){
                            {
                                this.customKey("select");
                                this.post(false);
                                this.effectParameter("color", "#000f");
                                this.neverStopRendering(true);
                                this.effectParameter("timeType", "infinite");
                            }
                        });
                        this.onClickEffect(new EffectBuilder("focus"){
                            {
                                this.effectParameter("targetElement", "#parent#parent");
                            }
                        });
                        this.interactOnClick("listBoxItemClicked()");
                    }
                });
            }
        };
        rowControlBuilder.registerControlDefintion(nifty);
        ScreenBuilder builder = new ScreenBuilder("start"){
            {
                this.layer(new LayerBuilder("layer"){
                    {
                        this.childLayoutCenter();
                        this.backgroundColor("#400f");
                        this.control((ControlBuilder)new ListBoxBuilder("serverBox"){
                            {
                                this.viewConverterClass(TableRowViewConverter.class);
                                this.displayItems(20);
                                this.hideHorizontalScrollbar();
                                this.width("765px");
                                this.height("500px");
                                this.childLayoutVertical();
                                this.optionalVerticalScrollbar();
                                this.alignCenter();
                                this.valignCenter();
                                this.control(new ControlBuilder("row"));
                            }
                        });
                    }
                });
            }
        };
        Screen startScreen = builder.build(nifty);
        ListBox listBox = (ListBox)startScreen.findNiftyControl("serverBox", ListBox.class);
        for (int i = 0; i < 1000; ++i) {
            listBox.addItem((Object)new TableRow(i, TableExampleMain.randomString(), TableExampleMain.randomString(), TableExampleMain.randomString(), TableExampleMain.randomString(), TableExampleMain.randomString()));
        }
        nifty.gotoScreen("start");
        LwjglInitHelper.renderLoop(nifty, null);
        LwjglInitHelper.destroy();
    }

    private static String randomString() {
        StringBuilder sb = new StringBuilder(5);
        for (int i = 0; i < 5; ++i) {
            sb.append(AB.charAt(rnd.nextInt(AB.length())));
        }
        return sb.toString();
    }

    private int $() {
        return 9;
    }

    public static class TableRowViewConverter
    implements ListBox.ListBoxViewConverter<TableRow> {
        public void display(Element listBoxItem, TableRow item) {
            for (int i = 0; i < 5; ++i) {
                Color color = new Color("#ff05");
                if (item.index % 2 == 0) {
                    color = new Color("#00f5");
                }
                Element textElement = listBoxItem.findElementByName("#col-" + String.valueOf(i));
                ((TextRenderer)textElement.getRenderer(TextRenderer.class)).setText(item.data[i]);
                ((PanelRenderer)listBoxItem.getRenderer(PanelRenderer.class)).setBackgroundColor(color);
            }
        }

        public int getWidth(Element listBoxItem, TableRow item) {
            int width = 0;
            for (int i = 0; i < 5; ++i) {
                TextRenderer renderer = (TextRenderer)listBoxItem.findElementByName("#col-" + String.valueOf(i)).getRenderer(TextRenderer.class);
                width += renderer.getFont().getWidth(item.data[i]);
            }
            return width;
        }
    }

    public static class TableRow {
        public int index;
        public String[] data = new String[5];

        public TableRow(int index, String ... param) {
            this.index = index;
            for (int i = 0; i < param.length; ++i) {
                this.data[i] = param[i];
            }
        }
    }
}

