/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.impl.x11;

import com.jogamp.nativewindow.impl.x11.X11Lib;
import com.jogamp.nativewindow.impl.x11.XVisualInfo;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesChooser;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.x11.X11GraphicsConfiguration;
import javax.media.nativewindow.x11.X11GraphicsScreen;

public class X11GraphicsConfigurationFactory
extends GraphicsConfigurationFactory {
    public AbstractGraphicsConfiguration chooseGraphicsConfiguration(Capabilities capabilities, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen) throws IllegalArgumentException, NativeWindowException {
        if (null == abstractGraphicsScreen || !(abstractGraphicsScreen instanceof X11GraphicsScreen)) {
            throw new NativeWindowException("Only valid X11GraphicsScreen are allowed");
        }
        return new X11GraphicsConfiguration((X11GraphicsScreen)abstractGraphicsScreen, capabilities, capabilities, X11GraphicsConfigurationFactory.getXVisualInfo(abstractGraphicsScreen, capabilities));
    }

    public static XVisualInfo getXVisualInfo(AbstractGraphicsScreen abstractGraphicsScreen, long l) {
        XVisualInfo xVisualInfo = XVisualInfo.create();
        xVisualInfo.setVisualid(l);
        xVisualInfo.setScreen(abstractGraphicsScreen.getIndex());
        int[] nArray = new int[]{-1};
        long l2 = abstractGraphicsScreen.getDevice().getHandle();
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo(l2, 3L, xVisualInfo, nArray, 0);
        if (xVisualInfoArray == null || nArray[0] < 1) {
            return null;
        }
        return XVisualInfo.create(xVisualInfoArray[0]);
    }

    public static XVisualInfo getXVisualInfo(AbstractGraphicsScreen abstractGraphicsScreen, Capabilities capabilities) {
        XVisualInfo xVisualInfo = X11GraphicsConfigurationFactory.getXVisualInfoImpl(abstractGraphicsScreen, capabilities, 4);
        if (null != xVisualInfo) {
            return xVisualInfo;
        }
        return X11GraphicsConfigurationFactory.getXVisualInfoImpl(abstractGraphicsScreen, capabilities, 5);
    }

    private static XVisualInfo getXVisualInfoImpl(AbstractGraphicsScreen abstractGraphicsScreen, Capabilities capabilities, int n) {
        XVisualInfo xVisualInfo = null;
        int[] nArray = new int[]{-1};
        XVisualInfo xVisualInfo2 = XVisualInfo.create();
        xVisualInfo2.setScreen(abstractGraphicsScreen.getIndex());
        xVisualInfo2.setC_class(n);
        long l = abstractGraphicsScreen.getDevice().getHandle();
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo(l, 2L, xVisualInfo2, nArray, 0);
        XVisualInfo xVisualInfo3 = null;
        int n2 = capabilities.getRedBits() + capabilities.getGreenBits() + capabilities.getBlueBits() + capabilities.getAlphaBits();
        for (int i = 0; xVisualInfoArray != null && i < nArray[0] && (xVisualInfo3 != null && xVisualInfo3.getDepth() >= xVisualInfoArray[i].getDepth() || n2 > (xVisualInfo3 = xVisualInfoArray[i]).getDepth()); ++i) {
        }
        if (null != xVisualInfo3 && (n2 <= xVisualInfo3.getDepth() || 24 == xVisualInfo3.getDepth())) {
            xVisualInfo = XVisualInfo.create(xVisualInfo3);
        }
        xVisualInfo3 = null;
        return xVisualInfo;
    }
}

