/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.joints;

import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HingeJoint
extends PhysicsJoint {
    protected Vector3f axisA;
    protected Vector3f axisB;
    protected boolean angularOnly = false;
    protected float biasFactor = 0.3f;
    protected float relaxationFactor = 1.0f;
    protected float limitSoftness = 0.9f;

    public HingeJoint() {
    }

    public HingeJoint(PhysicsRigidBody physicsRigidBody, PhysicsRigidBody physicsRigidBody2, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4) {
        super(physicsRigidBody, physicsRigidBody2, vector3f, vector3f2);
        this.axisA = vector3f3;
        this.axisB = vector3f4;
        this.createJoint();
    }

    public void enableMotor(boolean bl, float f, float f2) {
        this.enableMotor(this.objectId, bl, f, f2);
    }

    private native void enableMotor(long var1, boolean var3, float var4, float var5);

    public boolean getEnableMotor() {
        return this.getEnableAngularMotor(this.objectId);
    }

    private native boolean getEnableAngularMotor(long var1);

    public float getMotorTargetVelocity() {
        return this.getMotorTargetVelocity(this.objectId);
    }

    private native float getMotorTargetVelocity(long var1);

    public float getMaxMotorImpulse() {
        return this.getMaxMotorImpulse(this.objectId);
    }

    private native float getMaxMotorImpulse(long var1);

    public void setLimit(float f, float f2) {
        this.setLimit(this.objectId, f, f2);
    }

    private native void setLimit(long var1, float var3, float var4);

    public void setLimit(float f, float f2, float f3, float f4, float f5) {
        this.biasFactor = f4;
        this.relaxationFactor = f5;
        this.limitSoftness = f3;
        this.setLimit(this.objectId, f, f2, f3, f4, f5);
    }

    private native void setLimit(long var1, float var3, float var4, float var5, float var6, float var7);

    public float getUpperLimit() {
        return this.getUpperLimit(this.objectId);
    }

    private native float getUpperLimit(long var1);

    public float getLowerLimit() {
        return this.getLowerLimit(this.objectId);
    }

    private native float getLowerLimit(long var1);

    public void setAngularOnly(boolean bl) {
        this.angularOnly = bl;
        this.setAngularOnly(this.objectId, bl);
    }

    private native void setAngularOnly(long var1, boolean var3);

    public float getHingeAngle() {
        return this.getHingeAngle(this.objectId);
    }

    private native float getHingeAngle(long var1);

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.axisA, "axisA", (Savable)new Vector3f());
        outputCapsule.write((Savable)this.axisB, "axisB", (Savable)new Vector3f());
        outputCapsule.write(this.angularOnly, "angularOnly", false);
        outputCapsule.write(this.getLowerLimit(), "lowerLimit", 1.0E30f);
        outputCapsule.write(this.getUpperLimit(), "upperLimit", -1.0E30f);
        outputCapsule.write(this.biasFactor, "biasFactor", 0.3f);
        outputCapsule.write(this.relaxationFactor, "relaxationFactor", 1.0f);
        outputCapsule.write(this.limitSoftness, "limitSoftness", 0.9f);
        outputCapsule.write(this.getEnableMotor(), "enableAngularMotor", false);
        outputCapsule.write(this.getMotorTargetVelocity(), "targetVelocity", 0.0f);
        outputCapsule.write(this.getMaxMotorImpulse(), "maxMotorImpulse", 0.0f);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.axisA = (Vector3f)inputCapsule.readSavable("axisA", (Savable)new Vector3f());
        this.axisB = (Vector3f)inputCapsule.readSavable("axisB", (Savable)new Vector3f());
        this.angularOnly = inputCapsule.readBoolean("angularOnly", false);
        float f = inputCapsule.readFloat("lowerLimit", 1.0E30f);
        float f2 = inputCapsule.readFloat("upperLimit", -1.0E30f);
        this.biasFactor = inputCapsule.readFloat("biasFactor", 0.3f);
        this.relaxationFactor = inputCapsule.readFloat("relaxationFactor", 1.0f);
        this.limitSoftness = inputCapsule.readFloat("limitSoftness", 0.9f);
        boolean bl = inputCapsule.readBoolean("enableAngularMotor", false);
        float f3 = inputCapsule.readFloat("targetVelocity", 0.0f);
        float f4 = inputCapsule.readFloat("maxMotorImpulse", 0.0f);
        this.createJoint();
        this.enableMotor(bl, f3, f4);
        this.setLimit(f, f2, this.limitSoftness, this.biasFactor, this.relaxationFactor);
    }

    protected void createJoint() {
        this.objectId = this.createJoint(this.nodeA.getObjectId(), this.nodeB.getObjectId(), this.pivotA, this.axisA, this.pivotB, this.axisB);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Joint {0}", Long.toHexString(this.objectId));
    }

    private native long createJoint(long var1, long var3, Vector3f var5, Vector3f var6, Vector3f var7, Vector3f var8);
}

